//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "templateswindow.h"
#include "templatewindow.h"
#include "ui_templateswindow.h"

TemplatesWindow::TemplatesWindow(QWidget *parent, bool select) :
    QDialog(parent),
    ui(new Ui::TemplatesWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5NonComposited, true);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    if (!select)
        ui->btnOk->setVisible(false);

    connect(ui->btnAdd, SIGNAL(clicked()), SLOT(AddSlot()));
    connect(ui->btnEdit, SIGNAL(clicked()), SLOT(EditSlot()));
    connect(ui->btnRemove, SIGNAL(clicked()), SLOT(RemoveSlot()));
    connect(ui->btnOk, SIGNAL(clicked()), SLOT(OkSlot()));
    connect(ui->lstTemplates, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(TemplateDoubleClickSlot(QModelIndex)));
    PopulateTemplateList();
}

TemplatesWindow::~TemplatesWindow()
{
    delete ui;
    foreach(Template* t, m_List)
        delete t;
    m_List.clear();
}

void TemplatesWindow::PopulateTemplateList()
{
    ui->lstTemplates->clear();
    foreach(Template* t, m_List)
        delete t;
    m_List.clear();
    m_List = Template::GetTemplatesList();
    foreach (Template* t, m_List){
        QString text = t->Text;
        if (text.length() > 70)
            text = QString("%1...").arg(text.left(70));
        ui->lstTemplates->addItem(text);
    }
}


void TemplatesWindow::AddSlot()
{
    Template* t = new Template();
    TemplateWindow* frm = new TemplateWindow(this, t);
    if (frm->exec() == QDialog::Accepted)
        PopulateTemplateList();
    delete t;
    delete frm;    
}

void TemplatesWindow::EditSlot()
{
    if (ui->lstTemplates->currentIndex().row() >= 0){
        TemplateWindow* frm = new TemplateWindow(this, m_List.at(ui->lstTemplates->currentIndex().row()));
        if (frm->exec() == QDialog::Accepted)
            PopulateTemplateList();
        delete frm;
    }
}

void TemplatesWindow::RemoveSlot()
{
    if (ui->lstTemplates->currentIndex().row() >= 0){
        Template* t = m_List.at(ui->lstTemplates->currentIndex().row());
        if (CommonStatic::ConfirmMessage(this,
                                         tr("Confirm remove"),
                                         tr("Remove the selected template?")) == QMessageBox::Yes){
            t->Delete();
            PopulateTemplateList();
        }
    }
}

void TemplatesWindow::OkSlot()
{
    if (ui->lstTemplates->currentIndex().row() >= 0){
        m_SelectedTemplate = *m_List.at(ui->lstTemplates->currentIndex().row());
        accept();
    }
}

Template TemplatesWindow::GetSelectedTemplate()
{
    return m_SelectedTemplate;
}

void TemplatesWindow::TemplateDoubleClickSlot(QModelIndex)
{
    if (ui->btnOk->isVisible())
        OkSlot();
    else
        EditSlot();
}
