#include "template.h"
#include <QSqlRecord>
#include <QSqlQuery>
#include <QVariant>

Template::Template()
{
    Id = 0;
}

QList<Template*> Template::GetTemplatesList()
{
    QList<Template*> res;

    QString query = QString("Select t_id, t_subject, t_text from templates order by t_subject, t_text");
    QSqlQuery qry;
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return res;

    QSqlRecord rec;
    while(qry.next()){
        rec = qry.record();
        Template* t = new Template();
        t->Id = rec.value(0).toInt();
        t->Subject = rec.value(1).toString();
        t->Text = rec.value(2).toString();
        res.append(t);
    }

    return res;
}

bool Template::IsValid()
{
    return Id > 0;
}

bool Template::SaveToDb()
{
    QString query;
    if (!IsValid()){
        query = QString("insert into templates(t_subject, t_text) values('%1' ,'%2')")
                        .arg(CommonStatic::EscapeString(Subject)).arg(CommonStatic::EscapeString(Text));
    }else{
        query = QString("update templates set t_subject='%1', t_text='%2' where t_id=%3")
                        .arg(CommonStatic::EscapeString(Subject)).arg(CommonStatic::EscapeString(Text)).arg(Id);
    }

    if (!CommonStatic::ExecuteQuery(query))
        return false;
    return true;
}

bool Template::Delete()
{
    if (!IsValid())
        return false;

    QString query = QString("Delete from templates where t_id=%1").arg(Id);
    if (!CommonStatic::ExecuteQuery(query))
        return false;
    return true;
}
