//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSqlDatabase>
#include <QTableWidgetItem>
#include "group.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;

    bool m_OpeningGroup;
    QMenu* m_GroupMenu;
    QList<Group*> m_Groups;
    bool UpdateDB();
    QString GetDBVersion();
    void OpenDB();
    QSqlDatabase* m_Db;
    void PopulateGroupsTable();

public slots:
    void show();

private slots:
    void TimerSlot();
    void NewGroupSlot();
    void GroupClickedSlot(int row, int column);
    void AboutSlot();
    void ExitSlot();
    void GroupMenuSlot(QPoint point);
    void SendSmsToGroupSlot();
    void RemoveGroupSlot();
    void TemplatesSlot();
};

#endif // MAINWINDOW_H
