// -*- c++ -*-
//------------------------------------------------------------------------------
//                               FileSaveDialog.h
//------------------------------------------------------------------------------
// $Id: FileSaveDialog.h,v 1.1 2007/12/02 00:31:24 vlg Exp $
//------------------------------------------------------------------------------
//  Copyright (c) Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
#ifndef FILE_SAVE_DIALOG_H
#define FILE_SAVE_DIALOG_H

#include "Granule-main.h"
#include "Granule.h"

#ifdef IS_HILDON
#include <hildon-fmmm/hildon-fmmm.h>
#endif

#include <gtkmm/filechooserdialog.h>
#include <gtkmm/filechooser.h>
#include <gtkmm/fileselection.h>

#include <vector>

class FileSaveDialog
{
public:
	FileSaveDialog (const Glib::ustring& title_,
					Gtk::Widget*         parent_,
					const Glib::ustring& filter_name_    = "",
					const Glib::ustring& filter_pattern_ = "");

	~FileSaveDialog ();

	Glib::ustring get_filename     () const;
	void          set_current_name (const Glib::ustring& name_);

	int  run  ();
	void show ();
	void hide ();

private:

#ifdef IS_HILDON
	Hildon::FileChooserDialog* m_dialog;
#else
	Gtk::FileChooserDialog* m_dialog;
#endif
};

//------------------------------------------------------------------------------
// Inline functions
//------------------------------------------------------------------------------
inline Glib::ustring 
FileSaveDialog::
get_filename () const
{
	return (m_dialog->get_filename ());
}

inline void
FileSaveDialog::
set_current_name (const Glib::ustring& name_)
{
	m_dialog->set_current_name (name_);
}

inline int
FileSaveDialog::
run ()
{
	return (m_dialog->run ());
}
	
inline void
FileSaveDialog::
hide ()
{
	m_dialog->hide ();
}

inline void
FileSaveDialog::
show ()
{
	m_dialog->show ();
}



#endif /* FILE_SAVE_DIALOG_H */
