#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <glib.h>

/* #define DEBUG 1 */

G_BEGIN_DECLS

struct _GpsDataLoggerSettings {
    gboolean	method_agnss;
    gboolean	method_gnss;
    gboolean	method_acwp;
    gboolean	method_cwp;
    gint	interval;
    gboolean	auto_pause;
    gint	pause_speed_threshold;
    gint	pause_time_threshold;
    gboolean	save_filtered_log;
    char	*log_folder;
};

typedef struct _GpsDataLoggerSettings GpsDataLoggerSettings;

GpsDataLoggerSettings *settings_load (void);
gboolean settings_save (GpsDataLoggerSettings *);
void settings_free (GpsDataLoggerSettings *);

G_END_DECLS
#endif                          /* SETTINGS_H_ */
