/*
 * This file is part of gps-data-logger-widget
 *
 * Copyright (C) 2009-2011 Marcell Lengyel <marcell@maemo.org>
 *
 */

#include "gps-data-logger-gfx.h"

/* -------------------------------------------------------------------- */
/* Pixbufs and icons
 */

void
free_pixbuf(GdkPixbuf **pixbuf)
{
    if (*pixbuf)
    {
        g_object_unref(*pixbuf);
        *pixbuf = NULL;
    }
}

void
free_theme_pixbufs(GpsDataLoggerWidget * self)
{
    free_pixbuf(&self->button_bg);
    free_pixbuf(&self->button_pressed_bg);
}

void
load_theme_pixbufs(GpsDataLoggerWidget * self)
{
    self->button_bg = gdk_pixbuf_new_from_file(BUTTON_BG, NULL);
    self->button_pressed_bg = gdk_pixbuf_new_from_file(BUTTON_PRESSED_BG, NULL);
}

gboolean
theme_pixbufs_loaded(GpsDataLoggerWidget * self)
{
    if (self->button_bg && self->button_pressed_bg)
        return TRUE;

    return FALSE;
}

void
draw_pixbuf(cairo_t *cr, GdkPixbuf *pbuf, int x, int y, gboolean dimmed)
{
        int pbuf_width, pbuf_height;

        pbuf_width = gdk_pixbuf_get_width(pbuf);
        pbuf_height = gdk_pixbuf_get_height(pbuf);

        gdk_cairo_set_source_pixbuf(cr, pbuf,
                                    x - (pbuf_width / 2),
                                    y - (pbuf_height / 2));
        if (dimmed)
            cairo_paint_with_alpha(cr, 0.3);
        else
            cairo_paint(cr);
}

static void
draw_rounded_rectangle(cairo_t *cr, double x, double y,
                double width, double height, double rad)
{
        cairo_move_to(cr, x+rad, y);
        cairo_line_to(cr, x+width-rad, y);
        cairo_curve_to(cr, x+width, y, x+width, y, x+width, y+rad);
        cairo_line_to(cr, x+width, y+height-rad);
        cairo_curve_to(cr, x+width, y+height, x+width, y+height, x+width-rad, y+height);
        cairo_line_to(cr, x+rad, y+height);
        cairo_curve_to(cr, x, y+height, x, y+height, x, y+height-rad);
        cairo_line_to(cr, x, y+rad);
        cairo_curve_to(cr, x, y, x, y, x+rad, y);
        cairo_close_path(cr);
}

/* -------------------------------------------------------------------- */

void
draw_background(cairo_t *cr, GdkRectangle *area, gint border, gdouble transparency)
{
        cairo_pattern_t *grad;

        gdk_cairo_rectangle(cr, area);
        cairo_clip(cr);

        cairo_set_operator(cr, CAIRO_OPERATOR_OVER);

        /* Gradient background */
        grad = cairo_pattern_create_linear(area->x+border,
                        area->y+border, area->x+border,
                        area->y+area->height-(2*border));
        cairo_pattern_add_color_stop_rgba(grad, 0, 0.4, 0.4, 0.4, transparency);
        cairo_pattern_add_color_stop_rgba(grad, 1, 0.05, 0.05, 0.05, transparency);

        /* Draw border */
        cairo_set_line_width(cr, 2);
        draw_rounded_rectangle(cr, area->x+border,
                        area->y+border, area->width-(2*border),
                        area->height-(2*border), 10.0);
        cairo_set_source_rgba(cr, 0.4, 0.4, 0.4, transparency);
        cairo_stroke_preserve(cr);

        /* Fill background with gradient */
        cairo_set_source(cr, grad);
        cairo_fill(cr);

        cairo_pattern_destroy(grad);
}

