/*
 * This file is part of gps-data-logger-widget
 *
 * Copyright (C) 2009 Marcell Lengyel <marcell@maemo.org>
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 * root directory.
 *
 */

#ifndef GPS_DATA_LOGGER_WIDGET_H
#define GPS_DATA_LOGGER_WIDGET_H

#include <libhildondesktop/libhildondesktop.h>
#include <location/location-gpsd-control.h>
#include <location/location-gps-device.h>

#include <libosso.h>

#include "settings.h"

G_BEGIN_DECLS

/* Common struct types declarations */
typedef struct _GpsDataLoggerWidget GpsDataLoggerWidget;
typedef struct _GpsDataLoggerWidgetClass GpsDataLoggerWidgetClass;

/* Common macros */
#define GPS_TYPE_DATA_LOGGER_WIDGET            (gps_data_logger_widget_get_type ())
#define GPS_DATA_LOGGER_WIDGET(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GPS_TYPE_DATA_LOGGER_WIDGET, GpsDataLoggerWidget))
#define GPS_DATA_LOGGER_WIDGET_CLASS(klass) \
     	(G_TYPE_CHECK_CLASS_CAST ((klass),  GPS_TYPE_DATA_LOGGER_WIDGET, GpsDataLoggerWidgetClass))
#define GPS_IS_DATA_LOGGER_WIDGET(obj) \
	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPS_TYPE_DATA_LOGGER_WIDGET))
#define GPS_IS_DATA_LOGGER_WIDGET_CLASS(klass) \
	(G_TYPE_CHECK_CLASS_TYPE ((klass),  GPS_TYPE_DATA_LOGGER_WIDGET))
#define GPS_DATA_LOGGER_WIDGET_GET_CLASS(obj) \
       	(G_TYPE_INSTANCE_GET_CLASS ((obj),  GPS_TYPE_DATA_LOGGER_WIDGET, GpsDataLoggerWidgetClass))

typedef enum {
	APP_STATE_IDLE = 0,
	APP_STATE_STARTING,
	APP_STATE_RECORDING,
	APP_STATE_AUTO_PAUSED,
	APP_STATE_PAUSED,
	APP_STATE_STOPPING
} APP_STATE;

/* Instance struct */
struct _GpsDataLoggerWidget
{
	HDHomePluginItem parent;

	osso_context_t *osso_context;

	gboolean	has_comma_as_decimal_point;
	gint	 	app_state;
	gint		points_recorded_in_current_segment;
	double		auto_pause_time_mark;
	LocationGPSDControl *control;
	LocationGPSDevice *device;
	FILE		*file;
	gchar		*path;
#ifdef DEBUG
	FILE		*logfile;
#endif
	GtkWidget	*settings_dialog;
	GpsDataLoggerSettings *settings;
	/* Settings dialog widgets */
	GtkWidget 	*chk_method_agnss;
	GtkWidget 	*chk_method_gnss;
	GtkWidget 	*chk_method_acwp;
	GtkWidget 	*chk_method_cwp;
	GtkWidget 	*pkr_interval;
	GtkWidget	*chb_auto_pause;
	GtkWidget	*pkr_pause_speed_threshold;
	GtkWidget	*pkr_pause_time_threshold;
	GtkWidget 	*btn_path;
	/* Desktop widget */
	GtkWidget 	*background;
	GdkPixbuf 	*button_bg;
	GdkPixbuf 	*button_pressed_bg;
	GdkPixbuf	*rec_icon;
	GdkPixbuf	*pause_icon;
	GdkPixbuf	*stop_icon;
	GdkPixbuf	*gps_refresh_icon;
	GdkPixbuf	*gps_on_icon;
	GdkPixbuf	*gps_off_icon;
	GtkWidget	*gps_status;
	GtkWidget	*auto_pause_status;
	GtkWidget	*button_rec;
	GtkWidget	*button_stop;
	gboolean	rec_button_down;
	gboolean	rec_button_enabled;
	gboolean	pause_button_visible;
	gboolean	stop_button_down;
	gboolean	stop_button_enabled;
};

/* Class struct */
struct _GpsDataLoggerWidgetClass
{
	HDHomePluginItemClass parent_class;
};

GType  gps_data_logger_widget_get_type  (void);

G_END_DECLS

#endif
