#include "latitude.h"

LatitudeGUI::LatitudeGUI(QMainWindow *parent) : QMainWindow(parent) {
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    setWindowTitle(tr("Latitude & Buzz"));
    setting = new QSettings();

    // GUI
    url = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude");
    maps = new QWebView();
    maps->settings()->setAttribute(QWebSettings::PluginsEnabled, true);
    connect(maps, SIGNAL(loadFinished(bool)), this, SLOT(maps_login()));
    maps->load(url);
    menuBar()->addAction(tr("&Latitude"), this, SLOT(mode_latitude()));
    menuBar()->addAction(tr("&Buzz"), this, SLOT(mode_buzz()));
    menuBar()->addAction(tr("&Config"), this, SLOT(config()));

    // updater
    glatitude = new GoogleLatitude(this);
    gps = new GpsMaemo5(this);
    connect(gps, SIGNAL(fix()), this, SLOT(set()));
    connect(glatitude, SIGNAL(OK()), this, SLOT(latitude_OK()));
    connect(glatitude, SIGNAL(ERROR()), this, SLOT(latitude_ERROR()));

    // show it
    setCentralWidget(maps);
}

void LatitudeGUI::config() {
    // login input
    QDialog *dialoglogin = new QDialog(this);
    QLineEdit *login_user = new QLineEdit(setting->value("user","my_username").toString());
    QLineEdit *login_pass = new QLineEdit(setting->value("pass","my_password").toString());
    login_pass->setEchoMode(QLineEdit::Password);
    QLineEdit *login_freq = new QLineEdit(setting->value("freq","120").toString());
    QFormLayout *layout_login = new QFormLayout();
    layout_login->addRow(tr("&Username"), login_user);
    layout_login->addRow(tr("&Password"), login_pass);
    layout_login->addRow(tr("&Interval"), login_freq);
    connect(login_user, SIGNAL(textEdited(QString)), this, SLOT(save_user(QString)));
    connect(login_pass, SIGNAL(textEdited(QString)), this, SLOT(save_pass(QString)));
    connect(login_freq, SIGNAL(textEdited(QString)), this, SLOT(save_freq(QString)));
    connect(login_user, SIGNAL(returnPressed()), login_pass, SLOT(setFocus()));
    connect(login_pass, SIGNAL(returnPressed()), login_freq, SLOT(setFocus()));
    connect(login_freq, SIGNAL(returnPressed()), dialoglogin, SLOT(accept()));
    dialoglogin->setLayout(layout_login);
    dialoglogin->exec();

    set();
    mode_latitude();
    glatitude->reset();
}


void LatitudeGUI::set() {
    qDebug() << "LatitudeGUI: set";
    glatitude->login(setting->value("user","my_username").toString(),
                     setting->value("pass","my_password").toString());
    glatitude->freq(setting->value("freq","120").toInt());
    glatitude->set(gps->get_lat(),
                   gps->get_lon(),
                   gps->get_acc());
}

void LatitudeGUI::latitude_OK() {
    qDebug() << "LatitudeGUI: send";
}

void LatitudeGUI::latitude_ERROR() {
#ifdef Q_WS_MAEMO_5
    QString error_message = tr("<b>Error in Authentification!</b><br><br>") +
                            tr("Plese verify your login details<br>");
    QMaemo5InformationBox::information(this, error_message,
                                       QMaemo5InformationBox::NoTimeout);
#endif
    qDebug() << "LatitudeGUI: no auth";
    config();
}

void LatitudeGUI::save_user(QString _user) {
    setting->setValue("user", _user);
}
void LatitudeGUI::save_pass(QString _pass) {
    setting->setValue("pass", _pass);
}
void LatitudeGUI::save_freq(QString _freq) {
    setting->setValue("freq", _freq);
}
void LatitudeGUI::mode_buzz() {
    maps->load(QUrl::fromEncoded("http://www.google.com/maps/m?l-view=map&l-lci=m,com.google.latitudepublicupdates&ac=f,s,l"));
}

void LatitudeGUI::mode_latitude() {
    maps->load(QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude"));
}

void LatitudeGUI::maps_login() {
    if ( maps->url() == url ) {
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Email').value = \"%1\";").arg(
                        setting->value("user").toString()));
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Passwd').value = \"%1\";").arg(
                        setting->value("pass").toString()));
        maps->page()->mainFrame()->evaluateJavaScript("document.getElementById('gaia_loginform').submit();");
    }
}
