#ifndef LATITUDE_H
#define LATITUDE_H

#include <QtGui>
#include <QtWebKit>
#include <QtMaemo5>
#include "glatitude.h"
#include "gps.h"

class LatitudeGUI : public QMainWindow {
    Q_OBJECT

signals:
    void newpos();

public:
    LatitudeGUI(QMainWindow *parent = 0);

private slots:
    void set();
    void latitude_OK();
    void latitude_ERROR();
    void save_user(QString);
    void save_pass(QString);
    void maps_login();
    void mode_buzz();
    void mode_latitude();

private:
    GoogleLatitude *glatitude;
    GpsMaemo5 *gps;
    QSettings *setting;
    QWebView *maps;
    QUrl url;
};

#endif // LATITUDE_H
