#include "bin.h"

static void     gjiten_bin_class_init(gjiten_bin_class *_class);
static void     gjiten_bin_init(gjiten_bin *_bin);
static gboolean gjiten_bin_mnemonic_activate(GtkWidget *_wid,
 gboolean _group_cycling);
static void     gjiten_bin_size_request(GtkWidget *_wid,GtkRequisition *_req);
static void     gjiten_bin_size_allocate(GtkWidget *_wid,GtkAllocation *_alloc);

static GtkWidgetClass *parent_class;

GType gjiten_bin_get_type(void){
  static GType bin_type;
  if(!bin_type){
    static const GTypeInfo bin_info={
      sizeof(gjiten_bin_class),
      NULL,
      NULL,
      (GClassInitFunc)gjiten_bin_class_init,
      NULL,
      NULL,
      sizeof(gjiten_bin),
      0,
      (GInstanceInitFunc)gjiten_bin_init
    };
    bin_type=g_type_register_static(GTK_TYPE_BIN,"gjiten_bin",&bin_info,0);
  }
  return bin_type;
}

static void gjiten_bin_class_init(gjiten_bin_class *_class){
  GObjectClass      *gobject_class;
  GtkObjectClass    *object_class;
  GtkWidgetClass    *widget_class;
  gobject_class=G_OBJECT_CLASS(_class);
  object_class=(GtkObjectClass *)_class;
  widget_class=(GtkWidgetClass *)_class;
  parent_class=g_type_class_peek_parent(_class);
  widget_class->size_request=gjiten_bin_size_request;
  widget_class->size_allocate=gjiten_bin_size_allocate;
  widget_class->mnemonic_activate=gjiten_bin_mnemonic_activate;
}

static void gjiten_bin_init(gjiten_bin *_bin){
}

static void gjiten_bin_size_request(GtkWidget *_wid,GtkRequisition *_req){
  GtkBin *bin;
  bin=GTK_BIN(_wid);
  if(bin->child!=NULL&&GTK_WIDGET_VISIBLE(bin->child)){
    gtk_widget_size_request(bin->child,_req);
  }
  else _req->width=_req->height=0;
}

static void gjiten_bin_size_allocate(GtkWidget *_wid,GtkAllocation *_alloc){
  GtkBin *bin;
  bin=GTK_BIN(_wid);
  if(bin->child!=NULL&&GTK_WIDGET_VISIBLE(bin->child)){
    gtk_widget_size_allocate(bin->child,_alloc);
  }
}

static gboolean gjiten_bin_mnemonic_activate(GtkWidget *_wid,
 gboolean _group_cycling){
  if(!_group_cycling&&GTK_WIDGET_GET_CLASS(_wid)->activate_signal){
    gtk_widget_activate(_wid);
  }
  else if(GTK_WIDGET_CAN_FOCUS(_wid)){
    gtk_widget_grab_focus(_wid);
  }
  else if(GTK_IS_CONTAINER(_wid)){
    gtk_widget_child_focus(_wid,GTK_DIR_TAB_FORWARD);
  }
  else{
    g_warning("widget `%s' isn't suitable for mnemonic activation",
     G_OBJECT_TYPE_NAME(_wid));
  }
  return TRUE;
}

GtkWidget *gjiten_bin_new(void){
  return g_object_new(GJITEN_TYPE_BIN,NULL);
}
