#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gconf/gconf-client.h>

/*In order to provide multiple dictionary packages, we need the ability to add
   or remove dictionary files from the list without disturbing the rest of the
   list.
  Unfortunately, the text format returned by gconftool-2 is not terribly
   amenable to shell script parsing, due to the embedded newlines gjiten uses.
  This program is simple enough to do the job, and doesn't introduce a
   dependency on perl or other things.*/

int main(int _argc,char **_argv){
  GError      *error;
  GConfClient *client;
  GSList      *dics;
  GSList     **pdic;
  GSList      *dic;
  char        *name;
  char        *path;
  char        *p;
  if(_argc<2||_argc>3){
    fprintf(stderr,"Usage: %s <NAME> [<PATH>]\n"
     " NAME   The name of the dictionary to set.\n"
     " PATH   If present, the dictionary path is set to this value. If there\n"
     "        is no dictionary with this name, a new one is created. If PATH\n"
     "        is omitted, the dictionary is removed from the list, if it\n"
     "        exists.\n",
     _argv[0]);
    return -1;
  }
  name=_argv[1];
  path=_argc>2?_argv[2]:NULL;
  if(!gconf_init(0,NULL,&error)){
    fprintf(stderr,"GConf init failed: %s\n",error->message);
    return -1;
  }
  g_type_init();
  client=gconf_client_get_default();
  dics=gconf_client_get_list(client,"/apps/gjiten/general/dictionary_list",
   GCONF_VALUE_STRING,NULL);
  for(pdic=&dics,dic=dics;dic!=NULL;pdic=&dic->next,dic=dic->next){
    p=strchr((char *)dic->data,'\n');
    /*We found an existing dictionary with this name to replace.*/
    if(p!=NULL&&strcmp(p+1,name)==0)break;
  }
  /*Delete:*/
  if(path==NULL){
    if(dic!=NULL){
      *pdic=dic->next;
      g_free(dic->data);
      g_slist_free_1(dic);
    }
    /*Nothing to do.*/
    else return 0;
  }
  /*Add/Set:*/
  else{
    if(!g_file_test(path,G_FILE_TEST_EXISTS)){
      fprintf(stderr,"Could not find '%s'.\n",path);
      return -1;
    }
    if(dic==NULL)dics=g_slist_append(dics,g_strdup_printf("%s\n%s",path,name));
    else{
      g_free(dic->data);
      dic->data=g_strdup_printf("%s\n%s",path,name);
    }
  }
  if(dics!=NULL){
    gconf_client_set_list(client,"/apps/gjiten/general/dictionary_list",
     GCONF_VALUE_STRING,dics,NULL);
    g_slist_foreach(dics,(GFunc)g_free,NULL);
    g_slist_free(dics);
  }
  else gconf_client_unset(client,"/apps/gjiten/general/dictionary_list",NULL);
  return 0;
}
