/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef GMWENGINE_H
#define GMWENGINE_H

#include "data/gmwitem.h"
#include "data/gmwbusinessarea.h"

#include <QtNetwork/QNetworkReply>

#include <QtLocation/QGeoBoundingBox>

class GMWEngine : public QObject
{
    Q_OBJECT

public:
    GMWEngine();

    void setLocation(const QString &location);
    QString location();

    virtual QGeoBoundingBox startingBounds() = 0;

    virtual QStringList supportedLocations() = 0;

    virtual GMWBusinessArea businessArea() = 0;

public slots:
    virtual void refreshStationary(bool useCache = true) = 0;
    virtual void refreshVehicles(bool useCache = true) = 0;

signals:
    void objectsReceived(QList<GMWItem*> list);
    void downloadStarted();
    void downloadFinished(GMWItem::Type type, bool success, const QString &errorString);
    void downloadError(const QString &message);
    void loadedFromCache(GMWItem::Type type, const QDateTime &cacheDate);
    void locationChanged();

private:
    QString m_location;
};

#endif // GMWENGINE_H
