/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef MOBILITYMAP_H
#define MOBILITYMAP_H

#include "maps/gmwmap.h"

#include <QtGui/QGraphicsView>

#include <QtLocation/QGeoServiceProvider>
#include <QtLocation/QGeoMappingManager>
#include <QtLocation/QGeoPositionInfo>
#include <QtLocation/QGraphicsGeoMap>
#include <QtLocation/QGeoMapPixmapObject>
#include <QtLocation/QGeoRouteReply>
#include <QtLocation/QGeoMapRouteObject>

QTM_USE_NAMESPACE

class GMWMarker;
class GeoMap;
class MapView;

class MobilityMap : public GMWMap
{
    Q_OBJECT

public:
    explicit MobilityMap(GMWItemSortFilterProxyModel *model, QWidget *parent = 0);
    void initialize();

public slots:
    virtual void positionUpdated(const QGeoPositionInfo &info);
    virtual void moveTo(const QGeoCoordinate &point);
    virtual void routeTo(const QGeoCoordinate &point);
    virtual void zoomIn();
    virtual void zoomOut();
    virtual void zoomTo(const QGeoBoundingBox &bounds);
    virtual void refresh();
    virtual void setBusinessArea(const GMWBusinessArea &area);

    virtual QStringList supportedMapProviders() const;
    virtual QString mapProvider() const;
    virtual bool setMapProvider(const QString &provider);

protected slots:
    virtual void rowsInserted(const QModelIndex &parent, int start, int end);
    virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end);

    void routingFinished(QGeoRouteReply *reply);
    void routingError(QGeoRouteReply *reply, QGeoRouteReply::Error error, const QString &errorString);
private:
    QGeoServiceProvider        *m_serviceProvider;
    QGeoMappingManager         *m_mappingManager;
    GeoMap                     *m_map;
    QMap<GMWItem*, GMWMarker*>  m_items;
    QGeoMapPixmapObject        *m_positionMarker;
    MapView                    *m_view;
    QString                     m_providerName;
    QList<QGeoMapObject*>       m_businessAreaList;
    QGeoMapRouteObject          m_routeObject;

private slots:
    void animatedPanTo(const QGeoCoordinate &center);
    void geoObjectClicked(QGeoMapObject* object);
};

#endif // MOBILITYMAP_H
