#!/bin/sh
# Original script by Jebba, modified by 9000 @ talk.maemo.org
# Run this script to share your Internet connection.
# Activate your gprs0 (fone data) connection with the GUI

#run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
CONFIG=/home/user/.genwall/network.ini

IP_ADDR=`sed -n 's/wip=//gp' $CONFIG`
NETMASK=`sed -n 's/wnetm=//gp' $CONFIG`
DHCP_RANGE1=`sed -n 's/wdhcp1=//gp' $CONFIG`
DHCP_RANGE2=`sed -n 's/wdhcp2=//gp' $CONFIG`
RUNFILE="/var/run/wifi_tethering.pid"
DNSMASQ="/usr/sbin/dnsmasq"
ESSID=`sed -n 's/wessid=//gp' $CONFIG`
PASSWORD=`sed -n 's/wpass=//gp' $CONFIG`
CHANNEL=`sed -n 's/wch=//gp' $CONFIG`

set -x

start wlancond

# Load modules
#modprobe crc7
#modprobe mac80211
#modprobe wl12xx
#modprobe ipt_MASQUERADE

ifconfig wlan0 down
iwconfig wlan0 mode ad-hoc
ifconfig wlan0 up
iwconfig wlan0 essid $ESSID
iwconfig wlan0 key s:$PASSWORD
iwconfig wlan0 channel $CHANNEL
ifconfig wlan0 $IP_ADDR netmask $NETMASK up

if [ -f $RUNFILE ]
	     then
		 kill `cat $RUNFILE`
		 rm $RUNFILE
		 fi

# Setup DNS and DHCP
if [ "$1" = "lan" ] ; then
#start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ -- -k -I lo -z -a $IP_ADDR -F $DHCP_RANGE1,$DHCP_RANGE2 -b
#start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ -- -k -i wlan0 -I lo -z -a $IP_ADDR --address=/#/$IP_ADDR -F $DHCP_RANGE1,$DHCP_RANGE2,h6
start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ --  -z -R -i wlan0 -I lo -h -5 -p 0 -x $RUNFILE -F $DHCP_RANGE1,$DHCP_RANGE2,9999h --dhcp-option=6 --dhcp-option=3
fi

if [ "$1" = "for" ] ; then
start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ -- -k -I lo -z -a $IP_ADDR -F $DHCP_RANGE1,$DHCP_RANGE2 -b
fi

run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'WiFi HotSpot Activated'
