#include "helpwindow.h"
#include <qtextstream.h>
#include <QDebug>
#include <QMouseEvent>
#include <QMenu>
//#include <QSignalMapper>
#include <QFile>
//#include <QDir>

HelpWindow::HelpWindow(QTextEdit **ref,QStringList helpfiles) : QTextEdit()

{

    this->ref = ref;
    /*QStringList filters;
    filters << "*.html" ;
    QDir path("/home/user/.genwall/help");
    helpfiles = path.entryList(filters);
    helpfiles.replaceInStrings("_", " ");
    helpfiles.replaceInStrings(".html", "");*/
    hfiles=helpfiles;

    m_button = new QPushButton("go back", this);
        // set size and location of the button
        m_button->setGeometry(QRect(QPoint(680, 15),
                                     QSize(110, 45)));
        m_button->setStyleSheet("QPushButton{ background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 white, stop: 1 grey); border-style: solid; border-color: white; border-width: 5px; border-radius: 10px; }");

        // Connect button signal to appropriate slot
        connect(m_button, SIGNAL(released()), this, SLOT(button_goback()));
        this->viewport()->installEventFilter(this);


}
/*void HelpWindow::loadhfile(int index)
{
    QString helpfile = hfiles.at(index);
    helpfile.replace(" ", "_");
    helpfile = ("/home/user/.genwall/help/" + helpfile + ".html");
    QFile file(helpfile);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        qDebug() << "cannot open: " << helpfile;
        return;
    }

    QTextStream in(&file);
    this->clear();
    this->setHtml(in.readAll());
    file.close();
}*/
void HelpWindow::openfile()
{
    QObject *obj = sender();
    QString objName = obj->objectName();
    objName.replace(" ", "_");
    objName = ("/home/user/.genwall/help/" + objName + ".html");
    QFile file(objName);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        qDebug() << "cannot open: " << objName;
        return;
    }

    QTextStream in(&file);
    this->clear();
    this->setHtml(in.readAll());
    file.close();
}

bool HelpWindow::eventFilter(QObject *obj, QEvent *event)
{
    if(event->type() == QEvent::ContextMenu)
    {
        QMouseEvent *mouseEvent = static_cast<QMouseEvent*> (event);
        QMenu *menu = new QMenu(this);
        //QSignalMapper *mapper = new QSignalMapper(this);

        foreach(QString hfile, hfiles)
        {
            QAction * action = new QAction(hfile, this);
            action->setObjectName(hfile);
            menu->addAction(action);
            connect(action, SIGNAL(triggered()), this, SLOT(openfile()));
        }


        /*for(int i=0; i<hfiles.size(); i++){
           QAction* hfilesAction = new QAction(hfiles[i], this);
           hfilesAction->setCheckable(true);
           menu->addAction(hfilesAction);
           // Map this action to index i
             mapper->setMapping(hfilesAction, i);
             // Associate the toggled signal to map slot from the mapper
             // (it does not matter if we don't use the bool parameter from the signal)
             connect(hfilesAction, SIGNAL(toggled(bool)), mapper, SLOT(map()));

        }
        connect(mapper, SIGNAL(mapped(int)), this, SLOT(loadhfile(int)));*/

        menu->exec(mouseEvent->globalPos());

        return false;
    }
    else
        return QTextEdit::eventFilter(obj, event);
}
void HelpWindow::closeEvent(QCloseEvent * event)
{
    (void)event;
    emit setHelpButton(false,true);
    delete *ref; // or this. *ref should == this
    *ref = 0;
}

void HelpWindow::button_goback()
{
    emit setHelpButton(true,true);
}
