/****************************************************************************
 **
 ** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
 ** Contact: http://www.qt-project.org/legal
 **
 ** This file is part of the Qt Mobility Components.
 **
 ** $QT_BEGIN_LICENSE:BSD$
 ** You may use this file under the terms of the BSD license as follows:
 **
 ** "Redistribution and use in source and binary forms, with or without
 ** modification, are permitted provided that the following conditions are
 ** met:
 **   * Redistributions of source code must retain the above copyright
 **     notice, this list of conditions and the following disclaimer.
 **   * Redistributions in binary form must reproduce the above copyright
 **     notice, this list of conditions and the following disclaimer in
 **     the documentation and/or other materials provided with the
 **     distribution.
 **   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
 **     of its contributors may be used to endorse or promote products derived
 **     from this software without specific prior written permission.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 ** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 ** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 ** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 ** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 ** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 ** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 ** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 ** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 ** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 **
 ** $QT_END_LICENSE$
 **
 ****************************************************************************/

 #ifndef DEVICE_H
 #define DEVICE_H

 #include "ui_btdevice.h"

 #include <qmobilityglobal.h>
//#include "dropin/qmobilityglobal.h"
 #include <qbluetoothlocaldevice.h>
//#include "dropin/bluetooth/qbluetoothlocaldevice.h"
 #include <QDialog>
//namespace Ui
//{
//class DeviceDiscovery;
//}
 QTM_BEGIN_NAMESPACE
 class QBluetoothDeviceDiscoveryAgent;
 class QBluetoothDeviceInfo;
 //class QBluetoothLocalDevice;
 //class QBluetoothAddress;
 QTM_END_NAMESPACE

 QTM_USE_NAMESPACE

 class DeviceDiscoveryDialog : public QDialog
 {
     Q_OBJECT

 public:
     DeviceDiscoveryDialog(QWidget *parent = 0);
     ~DeviceDiscoveryDialog();

 public slots:
     void addDevice(const QBluetoothDeviceInfo&);
     //void on_power_clicked(bool clicked);
     //void on_discoverable_clicked(bool clicked);
     void displayPairingMenu(const QPoint &pos);
     void pairingDone(const QBluetoothAddress&, QBluetoothLocalDevice::Pairing);
     void pairingRequest(const QBluetoothAddress&, QString pin);
     void refreshTrusted(QString btaddress);

 private slots:
     void startScan();
     void scanFinished();
     void setGeneralUnlimited(bool unlimited);
     //void itemActivated(QListWidgetItem *item);
     void hostModeStateChanged(QBluetoothLocalDevice::HostMode);
     void show_service();

     void on_pushButton_btconnect_clicked();

     void bttrust_clicked();

     private:
     QBluetoothDeviceDiscoveryAgent *discoveryAgent;
     QBluetoothLocalDevice *localDevice;
     //Ui_DeviceDiscovery *ui;
         Ui::DeviceDiscovery *ui;

 signals:
     void acceptPairing(bool accept);
     void connectBT(QString btaddress, QString btservice);
     void setTrust(QString btaddress);

 };

 #endif
