/****************************************************************************
 **
 ** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
 ** Contact: http://www.qt-project.org/legal
 **
 ** This file is part of the Qt Mobility Components.
 **
 ** $QT_BEGIN_LICENSE:BSD$
 ** You may use this file under the terms of the BSD license as follows:
 **
 ** "Redistribution and use in source and binary forms, with or without
 ** modification, are permitted provided that the following conditions are
 ** met:
 **   * Redistributions of source code must retain the above copyright
 **     notice, this list of conditions and the following disclaimer.
 **   * Redistributions in binary form must reproduce the above copyright
 **     notice, this list of conditions and the following disclaimer in
 **     the documentation and/or other materials provided with the
 **     distribution.
 **   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
 **     of its contributors may be used to endorse or promote products derived
 **     from this software without specific prior written permission.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 ** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 ** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 ** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 ** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 ** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 ** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 ** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 ** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 ** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 **
 ** $QT_END_LICENSE$
 **
 ****************************************************************************/

 #include "btdevice.h"
 #include "btservice.h"

#include <QFile>
 #include <qbluetoothaddress.h>
//#include "dropin/bluetooth/qbluetoothaddress.h"
 #include <qbluetoothdevicediscoveryagent.h>
//#include "dropin/bluetooth/qbluetoothdevicediscoveryagent.h"
 #include <qbluetoothlocaldevice.h>
//#include "dropin/bluetooth/qbluetoothlocaldevice.h"
#include <QMessageBox>
#include <QMaemo5InformationBox>
 #include <QMenu>
 #include <QDebug>

 DeviceDiscoveryDialog::DeviceDiscoveryDialog(QWidget *parent)
 :   QDialog(parent), discoveryAgent(new QBluetoothDeviceDiscoveryAgent),
     localDevice(new QBluetoothLocalDevice),
     ui(new Ui::DeviceDiscovery)
 {
     ui->setupUi(this);

 #if defined (Q_OS_SYMBIAN) || defined(Q_OS_WINCE) || defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
     setWindowState(Qt::WindowFullScreen);
 #endif

     connect(ui->inquiryType, SIGNAL(toggled(bool)), this, SLOT(setGeneralUnlimited(bool)));
     connect(ui->scan, SIGNAL(clicked()), this, SLOT(startScan()));

     connect(discoveryAgent, SIGNAL(deviceDiscovered(const QBluetoothDeviceInfo&)),
             this, SLOT(addDevice(const QBluetoothDeviceInfo&)));
     connect(discoveryAgent, SIGNAL(finished()), this, SLOT(scanFinished()));

     //connect(ui->list, SIGNAL(itemActivated(QListWidgetItem*)),
       //      this, SLOT(itemActivated(QListWidgetItem*)));

     connect(localDevice, SIGNAL(hostModeStateChanged(QBluetoothLocalDevice::HostMode)),
             this, SLOT(hostModeStateChanged(QBluetoothLocalDevice::HostMode)));
     connect(localDevice, SIGNAL(pairingDisplayConfirmation(const QBluetoothAddress&, QString)),
                          this, SLOT(pairingRequest(const QBluetoothAddress&, QString)));
     connect(this, SIGNAL(acceptPairing(bool)), localDevice, SLOT(pairingConfirmation(bool)));

     hostModeStateChanged(localDevice->hostMode());
     // add context menu for devices to be able to pair device
     ui->list->setContextMenuPolicy(Qt::CustomContextMenu);
     connect(ui->list, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(displayPairingMenu(QPoint)));
     connect(localDevice, SIGNAL(pairingFinished(const QBluetoothAddress&, QBluetoothLocalDevice::Pairing))
         , this, SLOT(pairingDone(const QBluetoothAddress&, QBluetoothLocalDevice::Pairing)));
     QFile file("/home/user/.genwall/btdev.list");
     if (file.exists())
     {
         if(!file.open(QIODevice::ReadOnly | QIODevice::Text))
         {
             QMessageBox::information(0, "error", file.errorString());
             return;
         }
         //ui->list->clear();
         QStringList fields;
         QTextStream in(&file);

         while(!in.atEnd())
         {
             QString line = in.readLine();
             //QStringList fields = line.split(",");
             //QStringList fields = line.split(QRegExp("(\\r\\n)|(\\n\\r)|\\r|\\n"));
             fields.append(line);
         }
         ui->list->addItems(fields);
         file.close();
     }


 }

 DeviceDiscoveryDialog::~DeviceDiscoveryDialog()
 {
     delete discoveryAgent;
 }

 void DeviceDiscoveryDialog::addDevice(const QBluetoothDeviceInfo &info)
 {
     QString label = QString("%1 %2").arg(info.address().toString()).arg(info.name());
     QList<QListWidgetItem *> items = ui->list->findItems(label, Qt::MatchExactly);
     if(items.empty()) {
         QListWidgetItem *item = new QListWidgetItem(label);
         QBluetoothLocalDevice::Pairing pairingStatus = localDevice->pairingStatus(info.address());
         if (pairingStatus == QBluetoothLocalDevice::AuthorizedPaired )
             item->setTextColor(QColor(Qt::green));
         else if (pairingStatus == QBluetoothLocalDevice::Paired)
             item->setTextColor(QColor(Qt::blue));
         else
             item->setTextColor(QColor(Qt::white));

         ui->list->addItem(item);
     }

 }

 void DeviceDiscoveryDialog::startScan()
 {
     ui->list->clear();
     discoveryAgent->start();
     ui->scan->setEnabled(false);
     ui->inquiryType->setEnabled(false);
 }

 void DeviceDiscoveryDialog::scanFinished()
 {
     ui->scan->setEnabled(true);
     ui->inquiryType->setEnabled(true);
 }

 void DeviceDiscoveryDialog::setGeneralUnlimited(bool unlimited)
 {
     if (unlimited)
         discoveryAgent->setInquiryType(QBluetoothDeviceDiscoveryAgent::GeneralUnlimitedInquiry);
     else
         discoveryAgent->setInquiryType(QBluetoothDeviceDiscoveryAgent::LimitedInquiry);
 }

 /*void DeviceDiscoveryDialog::itemActivated(QListWidgetItem *item)
 {
     QString text = item->text();

     int index = text.indexOf(' ');

     if (index == -1)
         return;

     QBluetoothAddress address(text.left(index));
     QString name(text.mid(index + 1));

     ServiceDiscoveryDialog d(name, address);
     d.exec();
 }*/

 /*void DeviceDiscoveryDialog::on_discoverable_clicked(bool clicked)
 {
     if(clicked)
         localDevice->setHostMode(QBluetoothLocalDevice::HostDiscoverable);
     else
         localDevice->setHostMode(QBluetoothLocalDevice::HostConnectable);
 }*/

 /*void DeviceDiscoveryDialog::on_power_clicked(bool clicked)
 {
     if(clicked)
         localDevice->powerOn();
     else
         localDevice->setHostMode(QBluetoothLocalDevice::HostPoweredOff);
 }*/

 void DeviceDiscoveryDialog::hostModeStateChanged(QBluetoothLocalDevice::HostMode mode)
 {
     /*if(mode != QBluetoothLocalDevice::HostPoweredOff)
         ui->power->setChecked(true);
     else
        ui->power->setChecked( false);

     if(mode == QBluetoothLocalDevice::HostDiscoverable)
         ui->discoverable->setChecked(true);
     else
         ui->discoverable->setChecked(false);*/

     bool on = !(mode == QBluetoothLocalDevice::HostPoweredOff);

     ui->scan->setEnabled(on);
     //ui->discoverable->setEnabled(on);
 }
 void DeviceDiscoveryDialog::displayPairingMenu(const QPoint &pos)
 {
     QListWidgetItem *currentItem = ui->list->currentItem();

     if (currentItem==0) return;

     QString text = currentItem->text();
     int index = text.indexOf(' ');
     if (index == -1)
         return;
     //bool oldcon=false;
     if(text.left(1)== "#")
     {
         //oldcon=true;
         text.remove(0,1);
     }

     QMenu menu(this);
     QAction *pairAction = menu.addAction("Pair");
     QAction *pairAuthAction = menu.addAction("Auth Pair");
     QAction *trustAction =  menu.addAction("Trust");
     QAction *removePairAction = menu.addAction("Remove Pairing");
     QAction *serviceAction = menu.addAction("Show Service");
     QAction *chosenAction = menu.exec(ui->list->viewport()->mapToGlobal(pos));




     QBluetoothAddress address (text.left(index));
     if (chosenAction == pairAction) {

         localDevice->requestPairing(address, QBluetoothLocalDevice::Paired);
     }
     else if (chosenAction == pairAuthAction) {
         localDevice->requestPairing(address, QBluetoothLocalDevice::AuthorizedPaired);
     }
     else if (chosenAction == trustAction) {
         bttrust_clicked();
     }
     else if (chosenAction == removePairAction) {
         localDevice->requestPairing(address, QBluetoothLocalDevice::Unpaired);
         currentItem->setTextColor(QColor(Qt::white));
     }
     else if (chosenAction == serviceAction)
     {
         show_service();
     }
 }
 void DeviceDiscoveryDialog::refreshTrusted(QString btaddress)
 {
     QBluetoothAddress address (btaddress);
     QBluetoothLocalDevice::Pairing pairingStatus = localDevice->pairingStatus(address);
     QList<QListWidgetItem *> items = ui->list->findItems(address.toString(), Qt::MatchContains);

     if ( pairingStatus == QBluetoothLocalDevice::AuthorizedPaired ) {
         for (int var = 0; var < items.count(); ++var) {
             QListWidgetItem *item = items.at(var);
             item->setTextColor(QColor(Qt::green));
         }
     } else if (pairingStatus == QBluetoothLocalDevice::Paired){
         for (int var = 0; var < items.count(); ++var) {
             QListWidgetItem *item = items.at(var);
             item->setTextColor(QColor(Qt::blue));
         }
     }else {
         for (int var = 0; var < items.count(); ++var) {
             QListWidgetItem *item = items.at(var);
             item->setTextColor(QColor(Qt::white));
         }
 }
 }

 void DeviceDiscoveryDialog::pairingDone(const QBluetoothAddress &address, QBluetoothLocalDevice::Pairing pairing)
 {
     QList<QListWidgetItem *> items = ui->list->findItems(address.toString(), Qt::MatchContains);

     if ( pairing == QBluetoothLocalDevice::AuthorizedPaired ) {
         for (int var = 0; var < items.count(); ++var) {
             QListWidgetItem *item = items.at(var);
             item->setTextColor(QColor(Qt::green));
         }
     } else if (pairing == QBluetoothLocalDevice::Paired){
         for (int var = 0; var < items.count(); ++var) {
             QListWidgetItem *item = items.at(var);
             item->setTextColor(QColor(Qt::blue));
         }
     }else {
         for (int var = 0; var < items.count(); ++var) {
             QListWidgetItem *item = items.at(var);
             item->setTextColor(QColor(Qt::red));
         }
 }
 }
 void DeviceDiscoveryDialog::pairingRequest(const QBluetoothAddress &address, QString pin)
 {
     qDebug() << "pairingRequest slot\n";
     QMessageBox msgBox;
     msgBox.setText("Pair with " + address.toString() + " (PIN: " + pin + ") ?");
     //msgBox.setInformativeText("test");
     msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
     msgBox.setDefaultButton(QMessageBox::No);

     if(msgBox.exec() == QMessageBox::Yes) emit acceptPairing(true);


 }

void DeviceDiscoveryDialog::on_pushButton_btconnect_clicked()
{
    QListWidgetItem *item = ui->list->currentItem();
    bool oldcon=false;
    qDebug() << ui->list->currentItem();
    if (item!=0)
    {
        QString btservice=ui->comboBox_btservice->currentText();
        QString text = item->text();
        qDebug() << text;
        if (text.left(1)=="#")
        {
            text.remove(0,1);
            oldcon=true;
        }
        else
        {
            QFile file("/home/user/.genwall/btdev.list");

                if(!file.open(QIODevice::Append | QIODevice::Text))
                {
                    qDebug() << file.errorString();
                }
                QTextStream out(&file);
                out << "#" << text << endl;
                //qDebug() << line;
                file.close();
        }


        int index = text.indexOf(' ');

        if (index == -1)
            return;

        QBluetoothAddress address (text.left(index));
        QBluetoothLocalDevice::Pairing pairingStatus = localDevice->pairingStatus(address);
        //QString s_address(text.left(index));
        //QString name(text.mid(index + 1));
        if (pairingStatus == QBluetoothLocalDevice::AuthorizedPaired )
        {
            emit connectBT(text.left(index), btservice);
            this->accept();
        }
        else
        {
            QMaemo5InformationBox::information(this, "not paired or trusted\n please pair first", QMaemo5InformationBox::DefaultTimeout);

        }
    }
}

void DeviceDiscoveryDialog::show_service()
{
    QListWidgetItem *item = ui->list->currentItem();
    QString text = item->text();
    int index = text.indexOf(' ');

    if (index == -1)
        return;

    QBluetoothAddress address(text.left(index));
    QString name(text.mid(index + 1));

    ServiceDiscoveryDialog d(name, address);
    d.exec();
}

void DeviceDiscoveryDialog::bttrust_clicked()
{
    QListWidgetItem *item = ui->list->currentItem();
    if (item!=0)
    {
        QString text = item->text();
        int index = text.indexOf(' ');

        if (index == -1)
            return;

        emit setTrust(text.left(index));
    }

}
