#!/bin/sh

# by 9000 @ talk.maemo.org

# Prompt you to select the Internet connection. You may choose gprs or wifi
#run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_u

# Selecting and establishing connection takes time
#sleep 10

# Verbose mode. You can remove it when you're using widget to activate this script

set -x
CONFIG=/home/user/.genwall/network.ini

IP_ADDR=`sed -n 's/usbip=//gp' $CONFIG`
NETMASK=`sed -n 's/usbnetm=//gp' $CONFIG`
DHCP_RANGE1=`sed -n 's/usbdhcp1=//gp' $CONFIG`
DHCP_RANGE2=`sed -n 's/usbdhcp2=//gp' $CONFIG`
RUNFILE="/var/run/usb_tethering.pid"
DNSMASQ="/usr/sbin/dnsmasq"


# Setup bnep0
#ifconfig bnep0 down
#ifconfig bnep0 up
ifconfig usb0 $IP_ADDR netmask $NETMASK up

if [ -f $RUNFILE ]
	     then
		 kill `cat $RUNFILE`
		 rm $RUNFILE
		 fi

# Setup DNS and DHCP
if [ "$1" = "lan" ] ; then
#start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ -- -k -I lo -z -a $IP_ADDR -F $DHCP_RANGE1,$DHCP_RANGE2 -b
#start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ -- -k -i usb0 -I lo -z -a $IP_ADDR --address=/#/$IP_ADDR -F $DHCP_RANGE1,$DHCP_RANGE2,h6
start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ --  -z -R -i usb0 -I lo -h -5 -p 0 -F $DHCP_RANGE1,$DHCP_RANGE2,9999h --dhcp-option=6 --dhcp-option=3
fi

if [ "$1" = "for" ] ; then
start-stop-daemon -S -p $RUNFILE -m -b -x $DNSMASQ -- -k -I lo -z -a $IP_ADDR -F $DHCP_RANGE1,$DHCP_RANGE2 -b
fi

run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'USB Activated'
