#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "texteditautoresizer.h"
#include "rcqtextedit.h"
#include <QProcess>
#include <QFile>
#include <QDir>
#include <QMessageBox>
#include <QInputDialog>
#include <qtextstream.h>
#include <QDebug>
#include <addnowdialog.h>
#include <QSettings>
//qDebug() << "test";
//qDebug() << "number:" << QString::number(signalnr);
#include <QMaemo5InformationBox>
#include <QSystemDeviceInfo>
using namespace QtMobility;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
    new TextEditAutoResizer(ui->textEdit_log);
    new TextEditAutoResizer(ui->textEdit_filter);
    new TextEditAutoResizer(ui->textEdit_nat);
    new TextEditAutoResizer(ui->textEdit_lsof);
    connect(ui->textEdit_log, SIGNAL(valueChanged(int)),this, SLOT(getcontext_signal(int)));
    connect(ui->textEdit_filter, SIGNAL(valueChanged(int)),this, SLOT(getcontext_signal(int)));
    ui->page_log->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->page_log->setWindowFlags(Qt::Window);
    ui->page_setrule->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->page_setrule->setWindowFlags(Qt::Window);
    ui->page_optout->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->page_optout->setWindowFlags(Qt::Window);
    ui->page_optlog->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->page_optlog->setWindowFlags(Qt::Window);
    ui->page_real->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->page_real->setWindowFlags(Qt::Window);
    //ui->tabWidget_local->removeTab(6);
    if (QDir("/home/user/.genwall").exists()==false)
        QDir().mkdir("/home/user/.genwall");
    QFileInfo fi("/home/user/.genwall/settings.ini");
    if (fi.exists()){
        QSettings settings("/home/user/.genwall/settings.ini", QSettings::IniFormat);
        settings.beginGroup("LoSet");
        bool loadlist=settings.value("loadlist").toBool();
        bool loadwidget=settings.value("loadwidget").toBool();
        settings.endGroup();
        if (loadlist==true) {
            on_pushButton_loadloport_clicked();
            on_pushButton_loadfport_clicked();
            on_pushButton_loadrules_clicked();
        }

        if (loadwidget==true) {
            load_ini();
        }
    }
}

MainWindow::~MainWindow()
{
    delete ui;
}



void MainWindow::closeEvent(QCloseEvent *event)
{
    if (ui->checkBox_exitsave->checkState())
        save_ini();
    if (ui->checkBox_exitsavelist->checkState()) {
        on_pushButton_saveloport_clicked();
        on_pushButton_savefport_clicked();
        on_pushButton_saverules_clicked();
    }
    event->accept();
}

//config and settings
void MainWindow::save_ini()
{
    QSettings settings("/home/user/.genwall/settings.ini", QSettings::IniFormat);
    settings.beginGroup("LoBasics");
    settings.setValue("aconflo", ui->checkBox_lom->isChecked());
    settings.setValue("aconflan", ui->checkBox_lolan->isChecked());
    settings.setValue("dnetbios", ui->checkBox_netbios->isChecked());
    settings.setValue("synflood", ui->checkBox_losynprotect->isChecked());
    settings.setValue("syncheck", ui->checkBox_losyncheck->isChecked());
    settings.setValue("fragment", ui->checkBox_lofragment->isChecked());
    settings.setValue("stealth", ui->checkBox_stealth->isChecked());
    settings.setValue("wandev", ui->comboBox_wandev->currentIndex());
    settings.endGroup();
    settings.beginGroup("LoICMP");
    settings.setValue("disicmp",ui->checkBox_icmp->isChecked());
    settings.setValue("aechore",ui->checkBox_echoreplay->isChecked());
    settings.setValue("adestunr",ui->checkBox_destunr->isChecked());
    settings.setValue("atimeexc",ui->checkBox_icmptime->isChecked());
    settings.setValue("aecho",ui->checkBox_pingflood->isChecked());
    settings.setValue("lognomecho",ui->checkBox_icmpfire->isChecked());
    settings.setValue("icmpdev", ui->comboBox_icmpdev->currentIndex());
    settings.endGroup();
    settings.beginGroup("LoSSH");
    settings.setValue("asship", ui->checkBox_sship->isChecked());
    settings.setValue("sship", ui->lineEdit_sship->text());
    settings.endGroup();
    settings.beginGroup("LoSet");
    settings.setValue("incbadflag", ui->checkBox_incbadflags->isChecked());
    settings.setValue("incgainroot", ui->checkBox_incgainroot->isChecked());
    settings.setValue("savewidget", ui->checkBox_exitsave->isChecked());
    settings.setValue("savelist", ui->checkBox_exitsavelist->isChecked());
    settings.setValue("loadlist", ui->checkBox_loadliststart->isChecked());
    settings.setValue("loadwidget", ui->checkBox_loadoptions->isChecked());
    settings.endGroup();
    settings.beginGroup("Forward");
    settings.setValue("forward", ui->checkBox_forward->isChecked());
    settings.setValue("landev", ui->comboBox_landev->currentIndex());
    settings.setValue("cinvalid", ui->checkBox_invalidcon->isChecked());
    settings.setValue("masklan", ui->radioButton_masqlan->isChecked());
    settings.setValue("masksub", ui->radioButton_masqsub->isChecked());
    settings.setValue("maskip", ui->lineEdit_masqsub->text());
    settings.endGroup();
    settings.beginGroup("Output");
    settings.setValue("dout", ui->checkBox_output->isChecked());
    settings.setValue("aping", ui->checkBox_outping->isChecked());
    settings.setValue("logdrop", ui->checkBox_outlogdrop->isChecked());
    settings.setValue("aloop", ui->checkBox_outloop->isChecked());
    settings.setValue("adns", ui->checkBox_outdns->isChecked());
    settings.endGroup();
    settings.beginGroup("Chainslog");
    settings.setValue("afire", ui->checkBox_logfire->isChecked());
    settings.setValue("areject", ui->checkBox_logreject->isChecked());
    settings.setValue("abadflag", ui->checkBox_logbad->isChecked());
    settings.setValue("aout", ui->checkBox_outlogallow->isChecked());
    settings.setValue("filter", ui->comboBox_filterlog->currentIndex());
    settings.endGroup();
    settings.beginGroup("Logoptions");
    settings.setValue("date", ui->checkBox_optdate->isChecked());
    settings.setValue("time", ui->checkBox_opttime->isChecked());
    settings.setValue("chain", ui->checkBox_optname->isChecked());
    settings.setValue("in", ui->checkBox_optin->isChecked());
    settings.setValue("out", ui->checkBox_optout->isChecked());
    settings.setValue("mac", ui->checkBox_optmac->isChecked());
    settings.setValue("src", ui->checkBox_optsrc->isChecked());
    settings.setValue("dst", ui->checkBox_optdst->isChecked());
    settings.setValue("proto", ui->checkBox_optproto->isChecked());
    settings.setValue("spt", ui->checkBox_optspt->isChecked());
    settings.setValue("dpt", ui->checkBox_optdpt->isChecked());
    settings.setValue("type", ui->checkBox_opttype->isChecked());
    settings.setValue("filter", ui->checkBox_filteroutput->isChecked());
    settings.setValue("last", ui->checkBox_lastlogs->isChecked());
    settings.setValue("filter", ui->spinBox_lastlogs->value());
    settings.setValue("proto", ui->comboBox_optproto->currentIndex());
    settings.setValue("wrap", ui->checkBox_nowrap->isChecked());
    settings.endGroup();
    QMaemo5InformationBox::information(this, "settings saved",
                                                QMaemo5InformationBox::DefaultTimeout);

}

void MainWindow::load_ini()
{
    QFileInfo fi("/home/user/.genwall/settings.ini");
    if (!fi.exists()){
        QMaemo5InformationBox::information(this, "no file found",
                                                    QMaemo5InformationBox::DefaultTimeout);


    }
    else {
            QSettings settings("/home/user/.genwall/settings.ini", QSettings::IniFormat);
            settings.beginGroup("LoBasics");
            ui->checkBox_lom->setChecked(settings.value("aconflo").toBool());
            ui->checkBox_lolan->setChecked(settings.value("aconflan").toBool());
            ui->checkBox_netbios->setChecked(settings.value("dnetbios").toBool());
            ui->checkBox_losynprotect->setChecked(settings.value("synflood").toBool());
            ui->checkBox_losyncheck->setChecked(settings.value("syncheck").toBool());
            ui->checkBox_lofragment->setChecked(settings.value("fragment").toBool());
            ui->checkBox_stealth->setChecked(settings.value("stealth").toBool());
            ui->comboBox_wandev->setCurrentIndex(settings.value("wandev").toInt());
            settings.endGroup();
            settings.beginGroup("LoICMP");
            ui->checkBox_icmp->setChecked(settings.value("disicmp").toBool());
            ui->checkBox_echoreplay->setChecked(settings.value("aechore").toBool());
            ui->checkBox_destunr->setChecked(settings.value("adestunr").toBool());
            ui->checkBox_icmptime->setChecked(settings.value("atimeexc").toBool());
            ui->checkBox_pingflood->setChecked(settings.value("aecho").toBool());
            ui->checkBox_icmpfire->setChecked(settings.value("lognomecho").toBool());
            ui->comboBox_icmpdev->setCurrentIndex(settings.value("icmpdev").toInt());
            settings.endGroup();
            settings.beginGroup("LoSSH");
            ui->checkBox_sship->setChecked(settings.value("asship").toBool());
            settings.setValue("sship", ui->lineEdit_sship->text());
            ui->lineEdit_sship->setText(settings.value("sship").toString());
            settings.endGroup();
            settings.beginGroup("LoSet");
            ui->checkBox_incbadflags->setChecked(settings.value("incbadflag").toBool());
            ui->checkBox_incgainroot->setChecked(settings.value("incgainroot").toBool());
            ui->checkBox_exitsave->setChecked(settings.value("savewidget").toBool());
            ui->checkBox_exitsavelist->setChecked(settings.value("savelist").toBool());
            ui->checkBox_loadliststart->setChecked(settings.value("loadlist").toBool());
            ui->checkBox_loadoptions->setChecked(settings.value("loadwidget").toBool());
            settings.endGroup();
            settings.beginGroup("Forward");
            ui->checkBox_forward->setChecked(settings.value("forward").toBool());
            ui->checkBox_invalidcon->setChecked(settings.value("cinvalid").toBool());
            ui->comboBox_landev->setCurrentIndex(settings.value("landev").toInt());
            ui->radioButton_masqlan->setChecked(settings.value("masklan").toBool());
            ui->radioButton_masqsub->setChecked(settings.value("masksub").toBool());
            ui->lineEdit_masqsub->setText(settings.value("maskip").toString());
            settings.endGroup();
            settings.beginGroup("Output");
            ui->checkBox_output->setChecked(settings.value("dout").toBool());
            ui->checkBox_outping->setChecked(settings.value("aping").toBool());
            ui->checkBox_outlogdrop->setChecked(settings.value("logdrop").toBool());
            ui->checkBox_outloop->setChecked(settings.value("aloop").toBool());
            ui->checkBox_outdns->setChecked(settings.value("adns").toBool());
            settings.endGroup();
            settings.beginGroup("Chainslog");
            ui->checkBox_logfire->setChecked(settings.value("afire").toBool());
            ui->checkBox_logreject->setChecked(settings.value("areject").toBool());
            ui->checkBox_logbad->setChecked(settings.value("abadflag").toBool());
            ui->checkBox_outlogallow->setChecked(settings.value("aout").toBool());
            ui->comboBox_filterlog->setCurrentIndex(settings.value("filter").toInt());
            settings.endGroup();
            settings.beginGroup("Logoptions");
            ui->checkBox_optdate->setChecked(settings.value("date").toBool());
            ui->checkBox_opttime->setChecked(settings.value("time").toBool());
            ui->checkBox_optname->setChecked(settings.value("name").toBool());
            ui->checkBox_optin->setChecked(settings.value("in").toBool());
            ui->checkBox_optout->setChecked(settings.value("out").toBool());
            ui->checkBox_optmac->setChecked(settings.value("mac").toBool());
            ui->checkBox_optsrc->setChecked(settings.value("src").toBool());
            ui->checkBox_optdst->setChecked(settings.value("dst").toBool());
            ui->checkBox_optproto->setChecked(settings.value("proto").toBool());
            ui->checkBox_optspt->setChecked(settings.value("spt").toBool());
            ui->checkBox_optdpt->setChecked(settings.value("dpt").toBool());
            ui->checkBox_opttype->setChecked(settings.value("type").toBool());
            ui->checkBox_filteroutput->setChecked(settings.value("filter").toBool());
            ui->checkBox_lastlogs->setChecked(settings.value("last").toBool());
            ui->spinBox_lastlogs->setValue(settings.value("filter").toInt());
            ui->comboBox_optproto->setCurrentIndex(settings.value("proto").toInt());
            ui->checkBox_nowrap->setChecked(settings.value("wrap").toBool());
            settings.endGroup();
            QMaemo5InformationBox::information(this, "settings loaded",
                                                        QMaemo5InformationBox::DefaultTimeout);

        }
    }


//context menu
void MainWindow::getcontext_signal(int signalnr)
{
   if (signalnr == 1) {
       if (ui->tabWidget_main->currentIndex()==0) {
           refresh_filter();
       }
       else {
           on_pushButton_loadlog_clicked();
       }
    }
    else if (signalnr == 2) {
        if (ui->tabWidget_main->currentIndex()==0) {
            runtime_filter("DIALOG");
        }
        else {
        if (ui->listWidget_log->count() > 0)
        ui->page_log->show();
        else {
            QMessageBox msgBox;
            msgBox.setText("Rules creator only available\nfor Rejectwall and Outgoing filter log");
            //msgBox.setInformativeText("test");
            msgBox.setStandardButtons(QMessageBox::Ok);
            msgBox.setDefaultButton(QMessageBox::Ok);
            msgBox.exec();
        }
    }
    }
}


QString MainWindow::getfilter(QString ftype)
{
    QString prog = "sh";//shell
    //QString prog = "/sbin/ifconfig";
    QStringList arguments;
    //arguments << "-c" << "/sbin/ifconfig " + dev + " | grep \"inet \" | awk '{print $2}' | sed 's/addr://'";
    arguments << "-c" << "iptables -nL -v --line-numbers -t " + ftype;
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QString tmp=process->readAll();
    //if (tmp=="") tmp="Not available";
    //else tmp=tmp.left(tmp.count()-1);
    return tmp;
}


QString MainWindow::getlsof()
{
    QString prog = "sh";//shell
    //QString prog = "/sbin/ifconfig";
    QStringList arguments;
    //arguments << "-c" << "/sbin/ifconfig " + dev + " | grep \"inet \" | awk '{print $2}' | sed 's/addr://'";
    arguments << "-c" << "lsof -i4";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QString tmp=process->readAll();
    //if (tmp=="") tmp="Not available";
    //else tmp=tmp.left(tmp.count()-1);
    return tmp;
}
void MainWindow::refresh_filter()
{
    ui->textEdit_filter->clear();
    ui->textEdit_filter->setGeometry(9,9,709,319);
    ui->textEdit_filter->setMinimumSize(0,0);
    ui->textEdit_filter->setText(getfilter("filter"));
}


//####Local#####
void MainWindow::on_tabWidget_local_currentChanged(int index)
{
    if (index==3) {
        sshstatus();
    }
    else if (index==4) {
        refresh_filter();
    }
    else if (index==5) {
        ui->textEdit_lsof->clear();
        ui->textEdit_lsof->setGeometry(9,9,709,319);
        ui->textEdit_lsof->setMinimumSize(0,0);
        ui->textEdit_lsof->setText(getlsof());
    }
}


//####Local-Basics#####
void MainWindow::on_listWidget_real_doubleClicked(QModelIndex index)
{
    //int rowlist = index.row();
    QString indstr = ui->listWidget_real->item(index.row())->text();
    //int chainnr = indstr.mid(0,indstr.index.of(" ",0)-1).toInt();
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "iptables -D " + ui->label_realchain->text() + " " + indstr.mid(0,indstr.indexOf(" ",0));
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    runtime_filter("DIALOG");

}

int MainWindow::runtime_filter(QString type)
{
    QString runstr;
    QString chain;
    int item_epos=0;
    int item_spos=-1;
    int row=0;
    bool ok;
    QStringList runlistf;
    if (type=="DIALOG") {
    QStringList items;
         items << tr("INPUT") << tr("OUTPUT") << tr("FORWARD");


         chain = QInputDialog::getItem(this, tr("Select chain"),
                                              tr("Chain:"), items, 0, false, &ok);
    }
    else {
        chain=type;
        ok=true;
    }
         if (ok && !chain.isEmpty() ) {

         runstr=getfilter("filter");
         ui->listWidget_real->clear();
         ui->label_realchain->setText(chain);


         QStringList runlist = runstr.split(QRegExp("(\\r\\n)|(\\n\\r)|\\r|\\n"));
         //QStringList runlist = runstr.split(QRegExp("\\r"));
         for (int i=0; i < runlist.count(); ++i) {
             if (runlist.at(i).indexOf(chain)!=-1) {
                 item_spos=i;
                 break;
             }
         }

         //int item_spos=runlist.indexOf(chain,0);
         if (item_spos!=-1) {
         for (int i=item_spos; i < (runlist.count()); ++i) {
             if (runlist.at(i)=="") {
                 item_epos=i;
                 break;
             }
         }
         for (int i=item_spos + 2; i < item_epos; ++i) {
             runlistf.append(runlist.at(i));
         }
         if (type=="DIALOG") {
             ui->listWidget_real->addItems(runlistf);
             /*int item_spos=ui->listWidget_real->findItems(item,Qt::MatchContains).count();
             for (int i=item_spos; i < (ui->listWidget_real->count()); ++i) {
                 if (ui->listWidget_real->item(i)->text()=="") {
                     item_epos=i;
                     break;
                 }
             }
             for (int i=0; i < item_spos; ++i) {
                 ui->listWidget_real->removeItemWidget(0);
             }*/
             ui->page_real->show();


         }

         row=runlistf.count();
     }
     }

         return row;
}

void MainWindow::on_pushButton_start_clicked()
{
    QProcess *process = new QProcess(this);
    process->start("/home/user/.genwall/firestart.sh");
}

void MainWindow::on_pushButton_stop_clicked()
{
    if (QFile("/home/user/.genwall/firestop.sh").exists()==false) {
        QFile file("/home/user/.genwall/firestop.sh");
             if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
                 return;

             QTextStream out(&file);

             out << "#!/bin/sh" << "\n";
             out << "\n";
             if (ui->checkBox_incgainroot->checkState()) {
             out << "# gain superuser rights." << "\n";
             out << "\n";
             out << "if [ `id -u` != 0 ] ; then" << "\n";
             out << "exec sudo gainroot <<EOF" << "\n";
             out << "exec sh $0 $*" << "\n";
             out << "EOF" << "\n";
             out << "exit $?" << "\n";
             out << "fi   " << "\n";
             }
             out << "\n";
            out << "IPT=\"iptables\"" << "\n";
            out << "cat /proc/sys/net/ipv4/ip_forward >/dev/null;" << "\n";
            out << "if [ $? -eq 1 ]" << "\n";
            out << "then echo 0 > /proc/sys/net/ipv4/ip_forward;" << "\n";
            out << "fi;" << "\n";
            out << "\n";
            out << "for a in `cat /proc/net/ip_tables_names`; do" << "\n";
            out << "${IPT} -F -t $a" << "\n";
            out << "${IPT} -X -t $a" << "\n";
            out << "\n";
            out << "if [ $a = nat ]; then" << "\n";
            out << "${IPT} -t nat -P PREROUTING ACCEPT" << "\n";
            out << "${IPT} -t nat -P POSTROUTING ACCEPT" << "\n";
            out << "${IPT} -t nat -P OUTPUT ACCEPT" << "\n";
            out << "elif [ $a = mangle ]; then" << "\n";
            out << "${IPT} -t mangle -P PREROUTING ACCEPT" << "\n";
            out << "${IPT} -t mangle -P INPUT ACCEPT" << "\n";
            out << "${IPT} -t mangle -P FORWARD ACCEPT" << "\n";
            out << "${IPT} -t mangle -P OUTPUT ACCEPT" << "\n";
            out << "${IPT} -t mangle -P POSTROUTING ACCEPT" << "\n";
            out << "elif [ $a = filter ]; then" << "\n";
            out << "${IPT} -t filter -P INPUT ACCEPT" << "\n";
            out << "${IPT} -t filter -P FORWARD ACCEPT" << "\n";
            out << "${IPT} -t filter -P OUTPUT ACCEPT" << "\n";
            out << "fi" << "\n";
            out << "run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Iptable rules cleared!\"" << "\n";
            out << "done" << "\n";
            out << "\n";
            file.close();
            system("chmod 755 /home/user/.genwall/firestop.sh");
    }
    QProcess *process = new QProcess(this);
        process->start("/home/user/.genwall/firestop.sh");
}

void MainWindow::on_pushButton_gen_clicked()
{
    write_wall();
}

void MainWindow::write_wall()
{
    QString it_port;
    QString it_ip;
    QString it_prot;
    QString lo_port;
    QString lo_prot;
    QString lo_lan;
    QString lo_text;
    QFile file("/home/user/.genwall/firestart.sh");
         if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
             return;

         QTextStream out(&file);


        out << "#!/bin/sh" << "\n";
        out << "\n";
        if (ui->checkBox_incgainroot->checkState()) {
        out << "# gain superuser rights." << "\n";
        out << "\n";
        out << "if [ `id -u` != 0 ] ; then" << "\n";
        out << "exec sudo gainroot <<EOF" << "\n";
        out << "exec sh $0 $*" << "\n";
        out << "EOF" << "\n";
        out << "exit $?" << "\n";
        out << "fi   " << "\n";
        }
        out << "\n";
         out << "IPT=\"iptables\"" << "\n";
         out << "WAN=\"" << (ui->comboBox_wandev->currentText()) << "0\"" << "\n";
         out << "LAN=\"" << (ui->comboBox_landev->currentText()) << "0\"" << "\n";
         out << "\n";
         out << "$IPT -F" << "\n";
         out << "$IPT -F INPUT" << "\n";
         out << "$IPT -F OUTPUT" << "\n";
         out << "$IPT -F FORWARD" << "\n";
         out << "$IPT -F -t mangle" << "\n";
         out << "$IPT -F -t nat" << "\n";
         out << "$IPT -X" << "\n";
         out << "\n";
         out << "$IPT -P INPUT DROP" << "\n";
         if (ui->checkBox_output->checkState() || ui->checkBox_outlogallow->checkState())
             out << "$IPT -P OUTPUT DROP" << "\n";
         else
             out << "$IPT -P OUTPUT ACCEPT" << "\n";
         if (ui->checkBox_forward->checkState())
             out << "$IPT -P FORWARD ACCEPT" << "\n";
         else
             out << "$IPT -P FORWARD DROP" << "\n";

        out << "\n";
        if (ui->checkBox_losynprotect->checkState()) {
            out << "# SYN-flood attack protection" << "\n";
            out << "$IPT -A INPUT -p tcp --syn -m limit --limit 1/s -j ACCEPT" << "\n";
        }
        if (ui->checkBox_losynprotect->checkState() && ui->checkBox_forward->checkState()) {
            out << "$IPT -A FORWARD -p tcp --syn -m limit --limit 1/s -j ACCEPT" << "\n";
        }
        if (ui->checkBox_losyncheck->checkState()) {
            out << "# Make sure NEW incoming tcp connections are SYN packets; otherwise we need to drop them" << "\n";
            out << "$IPT -A INPUT -p tcp ! --syn -m state --state NEW -j DROP" << "\n";
        }
        if (ui->checkBox_lofragment->checkState()) {
            out << "# Packets with incoming fragments drop them." << "\n";
            out << "iptables -A INPUT -f -j DROP" << "\n";
        }


        out << "\n";
         if (ui->checkBox_forward->checkState()){
              out << "cat /proc/sys/net/ipv4/ip_forward >/dev/null;" << "\n";
              out << "if [ $? -eq 0 ]" << "\n";
              out << "then echo 1 > /proc/sys/net/ipv4/ip_forward;" << "\n";
              out << "fi;" << "\n";
         }
         else {
             out << "cat /proc/sys/net/ipv4/ip_forward >/dev/null;" << "\n";
             out << "if [ $? -eq 1 ]" << "\n";
             out << "then echo 0 > /proc/sys/net/ipv4/ip_forward;" << "\n";
             out << "fi;" << "\n";
         }
         out << "\n";
         if (ui->checkBox_forward->checkState() && ui->radioButton_masqlan->isChecked()){
             out << "$IPT -t nat -A POSTROUTING -o $WAN -j MASQUERADE" << "\n";}
         else if (ui->checkBox_forward->checkState() && ui->radioButton_masqsub->isChecked()){
              out << "$IPT -t nat -A POSTROUTING -s " << (ui->lineEdit_masqsub->text()) << " -j MASQUERADE" << "\n";}
         out << "\n";

         if (ui->checkBox_forward->checkState() && ui->listWidget_forwport->count()>0){
         for(int i=0; i < (ui->listWidget_forwport->count()); ++i) {
         it_port = (ui->listWidget_forwport->item(i)->text());
         int k=0;
         k=it_port.indexOf(";");
         it_ip=it_port.left(k);
         it_prot=it_port.right(it_port.count()-(k+1));
         k=it_prot.indexOf(";");
         it_port=it_prot.left(k);
         it_prot=it_prot.right(it_prot.count()-(k+1));
         k=it_port.indexOf(":");
         if (k==-1) {
             out << "$IPT -t nat -A PREROUTING -i $WAN -p " << it_prot << " --dport "<< it_port << " -j DNAT --to " << it_ip << ":" << it_port << "\n";
         }
         else out << "$IPT -t nat -A PREROUTING -i $WAN -p " << it_prot << " --dport "<< it_port << " -j DNAT --to " << it_ip << "\n";

         out << "$IPT -A FORWARD -i $WAN -p " << it_prot << " --dport "<< it_port << " -m state --state NEW -j ACCEPT" << "\n";
         }
     }
         out << "\n";
         if (ui->checkBox_invalidcon->checkState() && ui->checkBox_forward->checkState())
             out << "$IPT -A FORWARD -i $WAN -m state --state NEW,INVALID -j DROP" << "\n";
         out << "\n";

         if (ui->checkBox_lom->checkState())
             out << "$IPT -A INPUT -i lo -j ACCEPT" << "\n";

         if (ui->checkBox_lolan->checkState())
             out << "$IPT -A INPUT -i $LAN -j ACCEPT" << "\n";
         out << "\n";

         out << "$IPT -N Outallow" << "\n";
         if (ui->checkBox_outlogallow->checkState())
         out << "$IPT -A Outallow -m limit --limit 10/minute -j LOG --log-prefix \"Outallow: \"" << "\n";
         out << "$IPT -A Outallow -j ACCEPT" << "\n";
         out << "\n";

         out << "$IPT -N Outblock" << "\n";
         if (ui->checkBox_outlogdrop->checkState())
         out << "$IPT -A Outblock -m limit --limit 10/minute -j LOG --log-prefix \"Outblock: \"" << "\n";
         out << "$IPT -A Outblock -j DROP" << "\n";
         out << "\n";

         out << "$IPT -N Firewall" << "\n";
         if (ui->checkBox_logfire->checkState())
         out << "$IPT -A Firewall -m limit --limit 10/minute -j LOG --log-prefix \"Firewall: \"" << "\n";
         out << "$IPT -A Firewall -j DROP" << "\n";
         out << "\n";
         out << "$IPT -N Rejectwall" << "\n";
         if (ui->checkBox_logreject->checkState())
         out << "$IPT -A Rejectwall -m limit --limit 10/minute -j LOG --log-prefix \"Rejectwall: \"" << "\n";
         out << "$IPT -A Rejectwall -p tcp -j REJECT --reject-with tcp-rst" << "\n";
         out << "$IPT -A Rejectwall -j REJECT --reject-with icmp-host-unreachable" << "\n";
         //# use the following instead if you want to simulate that the host is not reachable
         //# for fun though
         //#$IPT -A Rejectwall -j REJECT  --reject-with icmp-host-unreachable
         out << "\n";
         if (ui->checkBox_incbadflags->checkState()) {
         out << "$IPT -N Badflags" << "\n";
         if (ui->checkBox_logbad->checkState())
         out << "$IPT -A Badflags -m limit --limit 10/minute -j LOG --log-prefix \"Badflags: \"" << "\n";
         out << "$IPT -A Badflags -j DROP" << "\n";

         out << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ACK,FIN FIN -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ACK,PSH PSH -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ACK,URG URG -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags FIN,RST FIN,RST -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags SYN,FIN SYN,FIN -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags SYN,RST SYN,RST -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ALL ALL -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ALL NONE -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ALL FIN,PSH,URG -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ALL SYN,FIN,PSH,URG -j Badflags" << "\n";
         out << "$IPT -A INPUT -p tcp --tcp-flags ALL SYN,RST,ACK,FIN,URG -j Badflags" << "\n";
         out << "\n";
         }
         //-------------------

         if (ui->checkBox_icmp->isChecked()) {
            out << "$IPT -A INPUT -p icmp -j DROP" << "\n";
        }
         else {
             if (ui->checkBox_echoreplay->isChecked() && ui->comboBox_icmpdev->currentText()=="all") { //0 => echo reply
                 out << "$IPT -A INPUT -p icmp --icmp-type 0 -j ACCEPT" << "\n";
             }
             else if (ui->checkBox_echoreplay->isChecked()) {
                 out << "$IPT -A INPUT -i $" << ui->comboBox_icmpdev->currentText() << " -p icmp --icmp-type 0 -j ACCEPT" << "\n";
             }
             if (ui->checkBox_destunr->isChecked() && ui->comboBox_icmpdev->currentText()=="all") { //3 => Destination Unreachable
                 out << "$IPT -A INPUT -p icmp --icmp-type 3 -j ACCEPT" << "\n";
             }
             else if (ui->checkBox_destunr->isChecked()) {
                 out << "$IPT -A INPUT -i $" << ui->comboBox_icmpdev->currentText() << " -p icmp --icmp-type 3 -j ACCEPT" << "\n";
             }
             if (ui->checkBox_icmptime->isChecked() && ui->comboBox_icmpdev->currentText()=="all") { //11 => Time Exceeded
                 out << "$IPT -A INPUT -p icmp --icmp-type 11 -j ACCEPT" << "\n";
             }
             else if (ui->checkBox_icmptime->isChecked()) {
                 out << "$IPT -A INPUT -i $" << ui->comboBox_icmpdev->currentText() << " -p icmp --icmp-type 11 -j ACCEPT" << "\n";
             }
             if (ui->checkBox_pingflood->isChecked() && ui->comboBox_icmpdev->currentText()=="all") { //8 => Echo
                 out << "$IPT -A INPUT -p icmp --icmp-type 8 -m limit --limit 1/second -j ACCEPT" << "\n";
             }
             else if (ui->checkBox_pingflood->isChecked()) {
                 out << "$IPT -A INPUT -i $" << ui->comboBox_icmpdev->currentText() << " -p icmp --icmp-type 8 -m limit --limit 1/second -j ACCEPT" << "\n";
             }
             if (ui->checkBox_icmpfire->isChecked()) { //block no match
                 out << "$IPT -A INPUT -p icmp -j Firewall" << "\n";
             }
         }
         if (ui->checkBox_outping->checkState() && ui->checkBox_output->checkState())
             out << "$IPT -A OUTPUT -p icmp --icmp-type 8 -j ACCEPT" << "\n";
         if (ui->checkBox_output->checkState()) {
             if (ui->checkBox_outloop->checkState())
                 out << "$IPT -A OUTPUT -o lo -j Outallow" << "\n";
             else if (ui->checkBox_outdns->checkState())
                 out << "$IPT -A OUTPUT -o lo -p udp -m multiport --dport 53,3001 -j ACCEPT" << "\n";
             out << "$IPT -A OUTPUT -m state --state ESTABLISHED,RELATED -j ACCEPT" << "\n";
             for (int i=0; i < (ui->listWidget_outopen->count()); ++i) {
                 QString out_text = (ui->listWidget_outopen->item(i)->text());
                 int k=0;
                 k=out_text.indexOf(";");
                 QString out_port=out_text.left(k);
                 out_text=out_text.right(out_text.count()-(k+1));
                 k=out_text.indexOf(";");
                 QString out_prot=out_text.left(k);
                 QString out_lan=out_text.right(out_text.count()-(k+1));
                 if (out_lan=="WAN") {
                     out << "$IPT -A OUTPUT -o $" << out_lan << " -p " << out_prot << " --dport "<< out_port << " -m state --state NEW -j Outallow" << "\n";}
                 else if (out_lan=="LAN") {
                     out << "$IPT -A OUTPUT -o $" << out_lan << " -p " << out_prot << " --dport "<< out_port << " -m state --state NEW -j Outallow" << "\n";
                 }
                 else if (out_lan=="all") {
                     out << "$IPT -A OUTPUT -p " << out_prot << " --dport "<< out_port << " -j Outallow" << "\n";
                 }
                 else if (out_lan=="lo" && ui->checkBox_outloop->isChecked()==false) {
                     out << "$IPT -A OUTPUT -o " << out_lan << "-p " << out_prot << " --dport "<< out_port << " -j Outallow" << "\n";
                 }
             }
         }

         if (ui->listWidget_loopen->count() > 0) {
             for (int i=0; i < (ui->listWidget_loopen->count()); ++i) {
                 lo_text = (ui->listWidget_loopen->item(i)->text());
                 int k=0;
                 k=lo_text.indexOf(";");
                 lo_port=lo_text.left(k);
                 lo_text=lo_text.right(lo_text.count()-(k+1));
                 k=lo_text.indexOf(";");
                 lo_prot=lo_text.left(k);
                 lo_lan=lo_text.right(lo_text.count()-(k+1));
                 if (lo_lan=="WAN") {
                     out << "$IPT -A INPUT -i $" << lo_lan << " -p " << lo_prot << " --dport "<< lo_port << " -j ACCEPT" << "\n";}
                 else if (ui->checkBox_lolan->isChecked()==false && lo_lan=="LAN") {
                     out << "$IPT -A INPUT -i $" << lo_lan << " -p " << lo_prot << " --dport "<< lo_port << " -j ACCEPT" << "\n";
                 }
             }
         }


        out << "\n";
        if (ui->checkBox_sship->checkState() && ui->lineEdit_sship->text()!="")
        out << "$IPT -A INPUT -s " << (ui->lineEdit_sship->text()) << " -p tcp --dport 22 -j ACCEPT" << "\n";
        out << "\n";


        //# Accept related and established connections
        out << "$IPT -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT" << "\n";

        //# Drop netbios from the outside, no log, just drop
        if (ui->checkBox_netbios->checkState() )
        out << "$IPT -A INPUT -p udp --sport 137 --dport 137 -j DROP" << "\n";

        if (ui->listWidget_rules->count()>0) {
            for (int i = 0; i < (ui->listWidget_rules->count()); ++i) {
                QString rule = (ui->listWidget_rules->item(i)->text());
                out << rule  << "\n";
            }
        }
        //stealth
        //out << "$IPT -A INPUT -j DROP" << "\n";
        //out << "$IPT -A INPUT -p udp -j REJECT --reject-with icmp-port-unreach" << "\n";
        //out << "$IPT -A INPUT -p tcp -j REJECT --reject-with tcp-rst" << "\n";
        if (ui->checkBox_outlogallow->checkState() && ui->checkBox_output->isChecked()==false)
            out << "$IPT -A OUTPUT -j Outallow" << "\n";
        if (ui->checkBox_output->checkState())
            out << "$IPT -A OUTPUT -j Outblock" << "\n";
        if (ui->checkBox_stealth->isChecked()) {
            out << "$IPT -A INPUT -j Firewall" << "\n";
        }
        else out << "$IPT -A INPUT -j Rejectwall" << "\n";
        out << "\n";
        out << "run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Iptable rules set!\"" << "\n";
         file.close();
         system("chmod 755 /home/user/.genwall/firestart.sh");

         QMaemo5InformationBox::information(this, "Generation complete",
                                                     QMaemo5InformationBox::DefaultTimeout);

}

void MainWindow::on_checkBox_icmp_stateChanged(int state)
{
    if (state == 0) {
            ui->frame_icmp->setEnabled(true);
        }
        else {
            ui->frame_icmp->setEnabled(false);
         }
}

//####Local-Ports#####
void MainWindow::on_pushButton_loaddnow_clicked()
{
    int anz=runtime_filter("INPUT");

    addnowDialog anDialog(QString::number(anz),this);
    if (anDialog.exec()==addnowDialog::Accepted) {
        anz=anDialog.getValue();
        QString intf=anDialog.getIntf();
        //ui->listWidget_loopen->addItem("iptables -I INPUT " + QString::number(anz) + " -i " + intf + " -p " + ui->comboBox_loprot->currentText() + " --dport " + ui->lineEdit_loport->text() + " -j ACCEPT");
        QString prog = "sh";//shell
        QStringList arguments;
    arguments << "-c" << "iptables -I INPUT " + QString::number(anz) + " -i " + intf + " -p " + ui->comboBox_loprot->currentText() + " --dport " + ui->lineEdit_loport->text() + " -j ACCEPT";
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        process->waitForFinished();
        QMaemo5InformationBox::information(this, "added rule",
                                                    QMaemo5InformationBox::DefaultTimeout);
    }

}

void MainWindow::on_pushButton_addloport_clicked()
{
    if (ui->lineEdit_loport->text()!="") {
        QString loport = ui->lineEdit_loport->text() + ";" + ui->comboBox_loprot->currentText() + ";" + ui->comboBox_allowlan->currentText();
        if (ui->listWidget_loopen->findItems(loport,Qt::MatchExactly).count()==0) {
            ui->listWidget_loopen->addItem(loport);
            ui->lineEdit_loport->setText("");
        }
    }
}

void MainWindow::on_pushButton_loportdel_clicked()
{
    //ui->lineEdit_loport->setText(ui->listWidget_loopen->item(ui->listWidget_loopen->currentRow())->text());
    if (ui->listWidget_loopen->currentItem())
    qDeleteAll(ui->listWidget_loopen->selectedItems());

    //ui->listWidget_loopen->(ui->listWidget_loopen->currentItem())
      //      delete ui.listWidget_loopen->item(0);
}

void MainWindow::on_pushButton_loportclear_clicked()
{
    ui->listWidget_loopen->clear();
}

void MainWindow::on_pushButton_saveloport_clicked()
{
    if (ui->listWidget_loopen->count()>0) {
    QFile file("/home/user/.genwall/loports.txt");
         if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
             return;

         QTextStream out(&file);

         for (int i=0; i < (ui->listWidget_loopen->count()); ++i) {
            QString lo_port = (ui->listWidget_loopen->item(i)->text());
            out << lo_port << "\n";
         }
         file.close();
    }
}

void MainWindow::on_pushButton_loadloport_clicked()
{
    QFile file("/home/user/.genwall/loports.txt");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }
    ui->listWidget_loopen->clear();
    QStringList fields;
    QTextStream in(&file);

    while(!in.atEnd()) {
        QString line = in.readLine();
        //QStringList fields = line.split(",");
        //QStringList fields = line.split(QRegExp("(\\r\\n)|(\\n\\r)|\\r|\\n"));

        fields.append(line);

    }
    ui->listWidget_loopen->addItems(fields);
    file.close();

}


//####Local-SSH#####
void MainWindow::on_checkBox_sship_clicked(bool checked)
{
    if (checked == true) {
        ui->lineEdit_sship->setEnabled(true);
    }
    else ui->lineEdit_sship->setEnabled(false);
}

//####Local-Settings#####
void MainWindow::on_pushButton_saveini_clicked()
{
    save_ini();
}

void MainWindow::on_pushButton_loadini_clicked()
{
    load_ini();
}

void MainWindow::on_pushButton_deleteset_clicked()
{

    ui->checkBox_exitsave->setChecked(false);
    ui->checkBox_exitsavelist->setChecked(false);
    deleteSettings("/home/user/.genwall/");
    this->close();
}

void MainWindow::deleteSettings(QString gendir)
{
    QDir gen_dir(gendir);

    //First delete any files in the current directory
    QFileInfoList files = gen_dir.entryInfoList(QDir::NoDotAndDotDot | QDir::Files);
    for(int file = 0; file < files.count(); file++)
    {
    gen_dir.remove(files.at(file).fileName());
    }

    //Now recursively delete any child directories
    QFileInfoList dirs = gen_dir.entryInfoList(QDir::NoDotAndDotDot | QDir::Dirs);
    for(int dir = 0; dir < dirs.count(); dir++)
    {
    this->deleteSettings(dirs.at(dir).absoluteFilePath ());
    }

    //Finally, remove empty parent directory
    gen_dir.rmdir(gen_dir.path());
}


//####Forward#####
void MainWindow::on_tabWidget_for_currentChanged(int index)
{
    if (index==2) {
        ui->textEdit_nat->clear();
        ui->textEdit_nat->setGeometry(9,9,709,319);
        ui->textEdit_nat->setMinimumSize(0,0);
        ui->textEdit_nat->append(getfilter("nat"));
    }
}


//####Forward-Basics#####
void MainWindow::on_checkBox_forward_stateChanged(int state)
{
    if (state == 0) {
        ui->frame_masq->setEnabled(false);
    }
    else ui->frame_masq->setEnabled(true);
}

void MainWindow::on_radioButton_masqsub_clicked(bool checked)
{
    if (checked == true)
        ui->lineEdit_masqsub->setEnabled(true);

}

void MainWindow::on_radioButton_masqlan_clicked(bool checked)
{
    if (checked == true)
        ui->lineEdit_masqsub->setEnabled(false);

}


//####Forward-Ports#####
void MainWindow::on_pushButton_addfport_clicked()
{
    if (ui->lineEdit_lanip->text()!="" && ui->lineEdit_lanport->text()!="") {
        QString fport=ui->lineEdit_lanip->text() + ";" + ui->lineEdit_lanport->text() + ";" + ui->comboBox_lanprot->currentText();
        if (ui->listWidget_forwport->findItems(fport,Qt::MatchExactly).count()==0) {
            ui->listWidget_forwport->addItem(fport);
            ui->lineEdit_lanport->setText("");
        }
    }
}

void MainWindow::on_pushButton_rmfport_clicked()
{

    //QList<QString> newlist;
    //newlist.append(ui->listWidget_forwport->selectedItems());
    //int it=newlist.count;
    if (ui->listWidget_forwport->currentItem())
    qDeleteAll(ui->listWidget_forwport->selectedItems());
}


void MainWindow::on_pushButton_clearfport_clicked()
{
    ui->listWidget_forwport->clear();
}

void MainWindow::on_pushButton_savefport_clicked()
{
    if (ui->listWidget_forwport->count()>0) {
    QFile file("/home/user/.genwall/fports.txt");
         if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
             return;

         QTextStream out(&file);

         for (int i=0; i < (ui->listWidget_forwport->count()); ++i) {
            QString lo_port = (ui->listWidget_forwport->item(i)->text());
            out << lo_port << "\n";
         }
         file.close();
    }
}

void MainWindow::on_pushButton_loadfport_clicked()
{
    QFile file("/home/user/.genwall/fports.txt");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }
    ui->listWidget_forwport->clear();
    QTextStream in(&file);

    while(!in.atEnd()) {
        QString line = in.readLine();
        //QStringList fields = line.split(",");
        //QStringList fields = line.split(QRegExp("(\\r\\n)|(\\n\\r)|\\r|\\n"));
        QStringList fields;
        fields.append(line);


        ui->listWidget_forwport->addItems(fields);
    }

    file.close();

}

//####Forward-Output#####
void MainWindow::on_checkBox_outloop_clicked(bool checked)
{
    if (checked == true) {
        ui->checkBox_outdns->setEnabled(false);
    }
    else ui->checkBox_outdns->setEnabled(true);
}

void MainWindow::on_checkBox_output_clicked(bool checked)
{
    if (checked == true) {
        ui->frame_output->setEnabled(true);
    }
    else ui->frame_output->setEnabled(false);
}

void MainWindow::on_pushButton_outportadd_clicked()
{
    if (ui->lineEdit_outport->text()!="") {
        QString outport=ui->lineEdit_outport->text() + ";" + ui->comboBox_outprot->currentText() + ";" + ui->comboBox_outnet->currentText();
        if (ui->listWidget_outopen->findItems(outport,Qt::MatchExactly).count()==0) {
            ui->listWidget_outopen->addItem(outport);
            ui->lineEdit_outport->setText("");
        }
    }
}

void MainWindow::on_pushButton_outportload_clicked()
{
    QFile file("/home/user/.genwall/outports.txt");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }
    ui->listWidget_outopen->clear();
    QTextStream in(&file);

    while(!in.atEnd()) {
        QString line = in.readLine();
        //QStringList fields = line.split(",");
        //QStringList fields = line.split(QRegExp("(\\r\\n)|(\\n\\r)|\\r|\\n"));
        QStringList fields;
        fields.append(line);


        ui->listWidget_outopen->addItems(fields);
    }

    file.close();

}

void MainWindow::on_pushButton_outportrm_clicked()
{
    if (ui->listWidget_outopen->currentItem())
    qDeleteAll(ui->listWidget_outopen->selectedItems());
}

void MainWindow::on_pushButton_outportsave_clicked()
{
    if (ui->listWidget_outopen->count()>0) {
    QFile file("/home/user/.genwall/outports.txt");
         if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
             return;

         QTextStream out(&file);

         for (int i=0; i < (ui->listWidget_outopen->count()); ++i) {
            QString outport = (ui->listWidget_outopen->item(i)->text());
            out << outport << "\n";
         }
         file.close();
    }
}

void MainWindow::on_pushButton_outportclear_clicked()
{
    ui->listWidget_outopen->clear();
}

void MainWindow::on_pushButton_outportmore_clicked()
{
    ui->page_optout->show();
}

//####Rules#####
void MainWindow::on_tabWidget_rules_currentChanged(int index)
{
    if (index==1) {
        QString pidofsys=getpidof("syslogd");
        ui->label_syslogd_pid->setText(pidofsys);
        ui->label_klogd_pid->setText(getpidof("klogd"));
        if (pidofsys=="none")
            ui->pushButton_rmsyslog->setEnabled(true);
        else ui->pushButton_rmsyslog->setEnabled(false);
    }
}


//####Rules-Extra#####
void MainWindow::on_pushButton_addrule_clicked()
{
    if (ui->lineEdit_rule->text()!="" && ui->listWidget_rules->findItems(ui->lineEdit_rule->text(),Qt::MatchExactly).count()==0)
        ui->listWidget_rules->addItem(ui->lineEdit_rule->text());
}

void MainWindow::on_pushButton_rmrule_clicked()
{
    if (ui->listWidget_rules->currentItem())
    qDeleteAll(ui->listWidget_rules->selectedItems());
}

void MainWindow::on_pushButton_editrule_clicked()
{
    if (ui->listWidget_rules->currentItem()) {
    ui->lineEdit_rule->setText(ui->listWidget_rules->item(ui->listWidget_rules->currentRow())->text());
    qDeleteAll(ui->listWidget_rules->selectedItems());
}
}

void MainWindow::on_pushButton_saverules_clicked()
{
    if (ui->listWidget_rules->count()>0) {
    QFile file("/home/user/.genwall/rules.txt");
         if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
             return;

         QTextStream out(&file);

         for (int i=0; i < (ui->listWidget_rules->count()); ++i) {
            QString rule = (ui->listWidget_rules->item(i)->text());
            out << rule << "\n";
         }
         file.close();
    }
}

void MainWindow::on_pushButton_loadrules_clicked()
{

    QFile file("/home/user/.genwall/rules.txt");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }
    ui->listWidget_rules->clear();
    QTextStream in(&file);

    while(!in.atEnd()) {
        QString line = in.readLine();
        QStringList fields;
        fields.append(line);
        ui->listWidget_rules->addItems(fields);
    }

    file.close();

}

void MainWindow::on_pushButton_clearrules_clicked()
{
    ui->listWidget_rules->clear();
}


//####Rules-Chains#####
QString MainWindow::getpidof(QString pname)
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "pidof " + pname;
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QString tmp=process->readAll();

    if (tmp=="") tmp="none";
    else tmp=tmp.left(tmp.count()-1);
    return(tmp);
}

void MainWindow::on_pushButton_startsysd_clicked()
{
    if (getpidof("syslogd")=="none") {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "start sysklogd";
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        process->waitForFinished();
        QMaemo5InformationBox::information(this, "syslogd started",
                                                    QMaemo5InformationBox::DefaultTimeout);
        ui->label_syslogd_pid->setText(getpidof("syslogd"));
        ui->pushButton_rmsyslog->setEnabled(false);
    }
}

void MainWindow::on_pushButton_stopsysd_clicked()
{
    if (getpidof("syslogd")!="none") {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "stop sysklogd";
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        process->waitForFinished();
        QMaemo5InformationBox::information(this, "syslogd stopped",
                                                    QMaemo5InformationBox::DefaultTimeout);
        ui->label_syslogd_pid->setText(getpidof("syslogd"));
        ui->pushButton_rmsyslog->setEnabled(true);
    }
}

void MainWindow::on_pushButton_rmsyslog_clicked()
{

    QMessageBox msgBox;
    msgBox.setText("Delete iptables.log?");
    //msgBox.setInformativeText("test");
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::No);

    if(msgBox.exec() == QMessageBox::Yes) {
    QFile file("/home/user/.genwall/iptables.log");
    if (file.remove()) {
        QMaemo5InformationBox::information(this, "deleted iptables.log",
                                                    QMaemo5InformationBox::DefaultTimeout);
    }}
}

void MainWindow::on_pushButton_startklogd_clicked()
{
    if (getpidof("klogd")=="none") {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "start klogd";
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        process->waitForFinished();
        QMaemo5InformationBox::information(this, "klogd started",
                                                    QMaemo5InformationBox::DefaultTimeout);
        ui->label_klogd_pid->setText(getpidof("klogd"));
        ui->pushButton_rmsyslog->setEnabled(false);
    }
}

void MainWindow::on_pushButton_stopklogd_clicked()
{
    if (getpidof("klogd")!="none") {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "stop klogd";
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        process->waitForFinished();
        QMaemo5InformationBox::information(this, "klogd stopped",
                                                    QMaemo5InformationBox::DefaultTimeout);
        ui->label_klogd_pid->setText(getpidof("klogd"));
        ui->pushButton_rmsyslog->setEnabled(true);
    }
}

void MainWindow::on_pushButton_loadlog_clicked()
{
    QStringList logs;
    QString line="";

    ui->textEdit_log->clear();
    ui->listWidget_log->clear();
    ui->textEdit_log->setGeometry(9,9,699,319);
    ui->textEdit_log->setMinimumSize(0,0);
    ui->textEdit_log->setFont(ui->fontComboBox_log->currentFont());
    ui->textEdit_log->setFontPointSize(ui->comboBox_logfontsize->currentText().toInt());
    ui->tabWidget_rules->setCurrentIndex(3);

    if (ui->checkBox_nowrap->checkState())
        ui->textEdit_log->setLineWrapMode(RCQTextEdit::NoWrap);
    else
        ui->textEdit_log->setLineWrapMode(RCQTextEdit::WidgetWidth);

    QFile file("/home/user/.genwall/iptables.log");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }

    QTextStream in(&file);

    while(!in.atEnd()) {
        line = in.readLine();

        if (ui->comboBox_filterlog->currentText()!="none") {
            if (ui->checkBox_filteroutput->checkState())
            {
                line = filterlog(line);
                if (line!="") logs.append(line);
            }
            else {
                if (line.indexOf(ui->comboBox_filterlog->currentText())!=-1) {
                    logs.append(line);
                }
            }
        }
        else ui->textEdit_log->append(line);
    }
    file.close();
    if (ui->checkBox_lastlogs->checkState()&&ui->comboBox_filterlog->currentText()!="none"&&logs.count()>(ui->spinBox_lastlogs->value())){
        int startlog = logs.count()-(ui->spinBox_lastlogs->value());
        for (int i = startlog; i < logs.count(); ++i){
            ui->textEdit_log->append(logs.at(i));
            if (ui->comboBox_filterlog->currentText()=="Rejectwall" || ui->comboBox_filterlog->currentText()=="Outblock" || ui->comboBox_filterlog->currentText()=="Outallow")
            ui->listWidget_log->addItem(logs.at(i));
        }
    }
    else if (ui->comboBox_filterlog->currentText()!="none") {
        for (int i = 0; i < logs.count(); ++i){
            ui->textEdit_log->append(logs.at(i));
            if (ui->comboBox_filterlog->currentText()=="Rejectwall" || ui->comboBox_filterlog->currentText()=="Outblock" || ui->comboBox_filterlog->currentText()=="Outallow")
            ui->listWidget_log->addItem(logs.at(i));
        }
    }    
}


//####Rules-Option#####
void MainWindow::on_checkBox_filteroutput_stateChanged(int state)
{
    if (state == 0) {
        ui->frame_rulesopt->setEnabled(false);
        ui->checkBox_lastlogs->setEnabled(false);
        ui->spinBox_lastlogs->setEnabled(false);
        ui->comboBox_optproto->setEnabled(false);
    }
    else {
        ui->frame_rulesopt->setEnabled(true);
        ui->checkBox_lastlogs->setEnabled(true);
        ui->spinBox_lastlogs->setEnabled(true);
        ui->comboBox_optproto->setEnabled(true);
    }
}

void MainWindow::on_pushButton_optmore_clicked()
{
    ui->page_optlog->show();
}


//####Rules-Log#####
//count for first " " and give str_position back
int MainWindow::cutterint(QString row, int place)
{
    int k=0;
    if (place==0) {
        k = row.indexOf(" ");
    }
    else {
    int count=0;

    int length=row.count();
    for (int i=0; i < length; ++i) {
    count=count+1;

    k=0;
    k=row.indexOf(" ",i);
    i=k+1;
    //ui->textEdit_log->append(QString::number(k));
    if (count==place){

    break;
}}
}
    return k+1;
}

//count spaces in string
int MainWindow::cuttercount(QString row)
{
    int k=0;
    int count=0;
    int length=row.count();
    for (int i=0; i < length; ++i) {
        count=count+1;
        k=0;
        k=row.indexOf(" ",i);
        i=k+1;
        //ui->textEdit_log->append(QString::number(k));


}
    return count;
}

QString MainWindow::cutter(QString row, QString cutstr, int place)
{

    QString ablage="";

    if (place==0) {
        ablage = row.mid(0, row.indexOf(cutstr));
    }
    else {
    int count=0;
    int k=0;
    int length=row.count();
    for (int i=0; i < length; ++i) {
    count=count+1;
    k=0;
    k=row.indexOf(cutstr,i);
    i=k+1;
    //ui->textEdit_log->append(QString::number(k));
    if (count==place){
     ablage = row.mid(k+1, row.indexOf(cutstr,k+1)-k-1);
    break;
}
}}
    return ablage;
}

QString MainWindow::write_filter(QString filterline)
{
    QString newline;
    QString ablage;
    QStringList paraname;
    QStringList paravalue;


        if (ui->checkBox_optdate->checkState()) {
            newline.append(cutter(filterline," ",0)+ " " + cutter(filterline," ",1));
        }
        if (ui->checkBox_opttime->checkState()) {
            newline.append(" "+cutter(filterline," ",2));
        }
        if (ui->checkBox_optname->checkState()) {
            int acut=filterline.indexOf(ui->comboBox_filterlog->currentText(),0);
            newline.append(" " + filterline.mid(acut,ui->comboBox_filterlog->currentText().count()+1));
            ablage=filterline.mid(acut+ui->comboBox_filterlog->currentText().count()+2,filterline.count()-ui->comboBox_filterlog->currentText().count()-2);
        }
        else {
            int acut=filterline.indexOf(ui->comboBox_filterlog->currentText(),0);
         ablage=filterline.mid(acut+ui->comboBox_filterlog->currentText().count()+2,filterline.count()-ui->comboBox_filterlog->currentText().count()-2);
     }

         int cucount=cuttercount(ablage);
         for (int i=0; i < cucount; ++i) {
             int offset=0;
             QString paran=(cutter(ablage,"=",0) + "=");
             int indx=paran.indexOf(" ");
             if (indx != -1) {
                 offset=indx+1;
                 //qDebug() << "listentry:" << QString::number(indx);
                 paran=paran.right(paran.count()-indx-1);
                 //qDebug() << paran;
                 //ablage=ablage.right(indx);
             }
             paraname.append(paran);
             //paran=paraname.at(i);

             paravalue.append(ablage.mid(paran.count()+offset,cutterint(ablage,0+offset)-paran.count()-1-offset));
             QString parav=paravalue.at(i);
             ablage=ablage.mid(paran.count()+parav.count()+1+offset,ablage.count()-paran.count()-parav.count()-1-offset);
         }
         if (ui->checkBox_optin->checkState()) {
             int poslist=paraname.indexOf("IN=",0);
            if (poslist!=-1) {
                newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
            }
         }
         if (ui->checkBox_optout->checkState()) {
             int poslist=paraname.indexOf("OUT=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_optmac->checkState()) {
             int poslist=paraname.indexOf("MAC=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_optsrc->checkState()) {
             int poslist=paraname.indexOf("SRC=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_optdst->checkState()) {
             int poslist=paraname.indexOf("DST=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_optproto->checkState()) {
             int poslist=paraname.indexOf("PROTO=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_optspt->checkState()) {
             int poslist=paraname.indexOf("SPT=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_optdpt->checkState()) {
             int poslist=paraname.indexOf("DPT=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }
         }
         if (ui->checkBox_opttype->checkState()) {
             int poslist=paraname.indexOf("TYPE=",0);
             if (poslist!=-1) {
                   newline.append(" "+paraname.at(poslist)+paravalue.at(poslist));
             }

          }
    newline=newline.trimmed();
    return newline;
}

QString MainWindow::filterlog(QString linelog)
{

    if (linelog.indexOf(ui->comboBox_filterlog->currentText())!=-1) {
        if (ui->comboBox_optproto->currentText()!="all") {
            if (linelog.indexOf(ui->comboBox_optproto->currentText(),0)!=-1) {
                linelog=write_filter(linelog);
            }
            else linelog="";
        }
        else linelog=write_filter(linelog);

    }
    else linelog="";

    return linelog;
}

void MainWindow::on_listWidget_log_doubleClicked(QModelIndex index)
{
    QString linelog;
    int checkc=0;
    int rowlist = index.row();
    //qDebug() << "listentry:" << QString::number(rowlist) << " " << ui->listWidget_log->item(rowlist)->text();
    linelog=ui->listWidget_log->item(rowlist)->text();
    QString filtertype=ui->comboBox_filterlog->currentText();

    if (linelog.indexOf("ICMP")==-1) {
        int startpos=0;
        int offsetpos=0;
        if (filtertype=="Rejectwall") {
            startpos=linelog.indexOf("IN=");
            offsetpos=3;
        }
        else {
            startpos=linelog.indexOf("OUT=");
            offsetpos=4;
        }
        if (startpos!=-1) {
            int endpos=linelog.indexOf(" ",startpos);
            ui->label_loginterface->setText(linelog.mid(startpos+offsetpos,endpos-offsetpos-startpos));
            //qDebug() << linelog.mid(startpos+3,endpos-3-startpos);
            //qDebug() << "startpos:" << QString::number(startpos);
            //qDebug() << "endpos:" << QString::number(endpos-3);
            checkc=checkc+1;
        }
        if (filtertype=="Rejectwall") {
            startpos=linelog.indexOf("SRC=");
            if (startpos!=-1) {
                int endpos=linelog.indexOf(" ",startpos);
                ui->label_logip->setText(linelog.mid(startpos+4,endpos-4-startpos));
                checkc=checkc+1;
            }
        }

        else {
            startpos=linelog.indexOf("DST=");
            int endpos=linelog.indexOf(" ",startpos);
            ui->label_logip->setText(linelog.mid(startpos+4,endpos-4-startpos));
            checkc=checkc+1;
        }

         startpos=linelog.indexOf("PROTO=");
         if (startpos!=-1) {
             int endpos=linelog.indexOf(" ",startpos);
             ui->label_logproto->setText((linelog.mid(startpos+6,endpos-6-startpos)).toLower());
             checkc=checkc+1;
         }
         startpos=linelog.indexOf("DPT=");
         if (startpos!=-1) {
             int endpos=linelog.indexOf(" ",startpos);
             ui->label_logdport->setText(linelog.mid(startpos+4,endpos-4-startpos));
             checkc=checkc+1;
         }
         if (checkc==4) {
             if (filtertype=="Rejectwall") {
                 ui->label_logruletype->setText("INPUT -i ");
                 ui->pushButton_rulefire->setText("Firewall chain (drop)");
                 ui->pushButton_ruledropall->setText("Drop all from IP");
                 ui->label_logiptype->setText("IP (src):");
                 ui->checkBox_currentip->setChecked(true);
                 //ui->checkBox_currentip->setEnabled(true);
             }
             else {
                 ui->label_logruletype->setText("OUPUT -o ");
                 ui->pushButton_rulefire->setText("Outblock chain (drop)");
                 ui->pushButton_ruledropall->setText("Drop all to IP");
                 ui->label_logiptype->setText("IP (dst):");
                 ui->checkBox_currentip->setChecked(false);
                 //ui->checkBox_currentip->setEnabled(false);
             }
             //ui->page_2->hide();
             ui->page_setrule->show();
         }
         else {
            ui->page_log->hide();
            ui->tabWidget_rules->setCurrentIndex(2);
             QMessageBox msgBox;
            msgBox.setText("Wrong filter set!");
            msgBox.setInformativeText("You need at least\nIN or OUT,SRC or DST,PROTO,DPT\nactivated.");
            msgBox.setStandardButtons(QMessageBox::Ok);
            msgBox.setDefaultButton(QMessageBox::Ok);
            msgBox.exec();

         }
     }
    else {
       //ui->page_log->hide();
       //ui->tabWidget_rules->setCurrentIndex(2);
        QMessageBox msgBox;
       msgBox.setText("ICMP not supported!");
       msgBox.setStandardButtons(QMessageBox::Ok);
       msgBox.setDefaultButton(QMessageBox::Ok);
       msgBox.exec();

    }
}

void MainWindow::on_pushButton_ruleaccept_clicked() //ui->label_logiptype->setText("IP (dst):");
{
    if (ui->checkBox_currentip->isChecked())
    ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -" + ui->label_logiptype->text().mid(4,1) + " " + ui->label_logip->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j ACCEPT");
    else ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j ACCEPT");
    QMaemo5InformationBox::information(this, "Extra Rule added!",
                                                QMaemo5InformationBox::DefaultTimeout);

}

void MainWindow::on_pushButton_rulenow_clicked()
{
    QString prog = "sh";//shell
    QStringList arguments;
    if (ui->label_logruletype->text().indexOf("INPUT",0)!=-1) {
        if (ui->checkBox_currentip->isChecked()) {
            arguments << "-c" << "iptables --insert " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -" + ui->label_logiptype->text().mid(4,1) + " " + ui->label_logip->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j ACCEPT";
        }
        else {
            arguments << "-c" << "iptables --insert " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j ACCEPT";
        }
    }

    else {
        if (ui->checkBox_currentip->isChecked()) {
            arguments << "-c" << "iptables --insert " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j ACCEPT";
        }
        else {
            arguments << "-c" << "iptables --insert " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j ACCEPT";
        }

    }
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
}

void MainWindow::on_pushButton_ruledrop_clicked()
{
    if (ui->checkBox_currentip->isChecked())
    ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -" + ui->label_logiptype->text().mid(4,1) + " " + ui->label_logip->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j DROP");
    else ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j DROP");
    QMaemo5InformationBox::information(this, "Extra Rule added!",
                                                QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::on_pushButton_ruledropall_clicked()
{
    ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -" + ui->label_logiptype->text().mid(4,1) + " " + ui->label_logip->text() + " -p all -j DROP");

    QMaemo5InformationBox::information(this, "Extra Rule added!",
                                                QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::on_pushButton_rulefire_clicked()
{
    if (ui->checkBox_currentip->isChecked()) {
        if (ui->label_logruletype->text()=="INPUT:")
            ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -" + ui->label_logiptype->text().mid(4,1) + " " + ui->label_logip->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j Firewall");
        else
            ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -" + ui->label_logiptype->text().mid(4,1) + " " + ui->label_logip->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j Outblock");
    }

    else if (ui->label_logruletype->text()=="INPUT:") {
        ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j Firewall");
    }
    else if (ui->label_logruletype->text()=="OUTPUT:") {
        ui->listWidget_rules->addItem("iptables -A " + ui->label_logruletype->text() + ui->label_loginterface->text() + " -p " + ui->label_logproto->text() + " --dport " + ui->label_logdport->text() + " -j Outblock");
    }

    QMaemo5InformationBox::information(this, "Extra Rule added!",
                                                QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::on_pushButton_gomain_clicked()
{
    ui->page_log->hide();
    ui->page_setrule->hide();
    ui->tabWidget_main->setCurrentIndex(0);
}

void MainWindow::on_pushButton_goextra_clicked()
{
    ui->page_log->hide();
    ui->page_setrule->hide();
    ui->tabWidget_rules->setCurrentIndex(0);
}


//####Route#####

void MainWindow::on_tabWidget_route_currentChanged(int index)
{
    if (index==1) {
        ui->label_usbip->setText(getip("usb0"));
        ui->label_gprsip->setText(getip("gprs0"));
        ui->label_bnepip->setText(getip("bnep0"));
        ui->label_wlanip->setText(getip("wlan0"));
    }
    else if (index==2) {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "/sbin/route -n";
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        process->waitForFinished();
        QString tmp=process->readAll();
        //if (tmp=="") tmp="Not available";
        ui->textEdit_routet->setText(tmp);
    }
    else if (index==3) {
        wload_ini();
        checkwmode();
        wifistatus();
    }
    else if (index==4) {
        getrev();
        getos();
        getkernel();
        getimei();
        getimsi();
        getpower();
    }

}

//####Route-Gate#####
void MainWindow::on_pushButton_gweadd_clicked()
{
    QString gw = ui->lineEdit_gw->text();
    if (gw!="") {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "/sbin/route add default gw " + gw;
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        /*process->waitForFinished();
        QString tmp=process->readAll();
        //if (tmp=="") tmp="Not available";
        ui->textEdit_routet->setText(tmp);*/
    }
}

void MainWindow::on_pushButton_gwdel_clicked()
{
    QString gw = ui->lineEdit_gw->text();
    if (gw!="") {
        QString prog = "sh";//shell
        QStringList arguments;
        arguments << "-c" << "/sbin/route del default gw " + gw;
        QProcess* process = new QProcess(this);
        process->start(prog, arguments);
        /*process->waitForFinished();
        QString tmp=process->readAll();
        //if (tmp=="") tmp="Not available";
        ui->textEdit_routet->setText(tmp);*/
    }

}

void MainWindow::on_pushButton_routedefaultadd_clicked()
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "/sbin/route add default dev " + ui->comboBox_routedev->currentText() + "0";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
}

void MainWindow::on_pushButton_routedefaultdel_clicked()
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "/sbin/route del default dev " + ui->comboBox_routedev->currentText() + "0";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
}

void MainWindow::on_pushButton_adddns_clicked()
{
    QString prog = "sh";//shell
    QStringList arguments;
    if (ui->lineEdit_dns2->text()!="")
    arguments << "-c" << "echo nameserver=" + ui->lineEdit_dns1->text() + " > /etc/resolv.conf && echo nameserver=" + ui->lineEdit_dns2->text() + " >> /etc/resolv.conf";
    else arguments << "-c" << "echo nameserver=" + ui->lineEdit_dns1->text() + " > /etc/resolv.conf";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
}

void MainWindow::on_pushButton_resetdns_clicked()
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "echo nameserver=127.0.0.1 > /etc/resolv.conf";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
}

void MainWindow::on_pushButton_showresolv_clicked()
{
    QFile file("/etc/resolv.conf");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }
    ui->textEdit_resolv->clear();
    QTextStream in(&file);

    while(!in.atEnd()) {
        QString line = in.readLine();
        //QStringList fields = line.split(",");
        //QStringList fields = line.split(QRegExp("(\\r\\n)|(\\n\\r)|\\r|\\n"));
        ui->textEdit_resolv->append(line);
    }
    file.close();
}


//####Route-IP Info#####
QString MainWindow::getip(QString dev)
{
    QString prog = "sh";//shell
    //QString prog = "/sbin/ifconfig";
    QStringList arguments;
    arguments << "-c" << "/sbin/ifconfig " + dev + " | grep \"inet \" | awk '{print $2}' | sed 's/addr://'";
    //arguments << "usb0 | grep \"inet\" | awk '{print $2}' | sed 's/addr://' ";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QString tmp=process->readAll();
    if (tmp=="") tmp="Not available";
    else tmp=tmp.left(tmp.count()-1);
    return tmp;
}

void MainWindow::on_pushButton_ipinfo_clicked()
{
    ui->label_usbip->setText(getip("usb0"));
    ui->label_gprsip->setText(getip("gprs0"));
    ui->label_bnepip->setText(getip("bnep0"));
    ui->label_wlanip->setText(getip("wlan0"));
}

void MainWindow::getpower()
{
    QSystemDeviceInfo s;
    ui->label_power->setText("Power: " + QString::number(s.batteryLevel())+ "%");
}

void MainWindow::getimsi()
{
    QSystemDeviceInfo s;
    ui->label_imsi->setText("IMSI: " + s.imsi());
}

void MainWindow::getimei()
{
    QSystemDeviceInfo s;
    ui->label_imei->setText("IMEI: " + s.imei());
}

void MainWindow::getos()
{
    QByteArray envname = qgetenv("OSSO_VERSION");
    ui->label_os->setText("OS: \t" + envname);
}

/*void MainWindow::getos()
{
    QSystemInfo s;
    QString os=s.version(QSystemInfo::Os);
    QString firm=s.version(QSystemInfo::Firmware);
    ui->label_os->setText("OS: PR" + os + "\tFirmware: " + firm);
}*/

void MainWindow::getkernel()
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "uname -r";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QString tmp=process->readAll();
    if (tmp=="") tmp="Not available";
    //else tmp=tmp.left(tmp.count()-1);
    ui->label_kernel->setText("Kernel: \t" + tmp);
}

void MainWindow::getrev()
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "cat /proc/cpuinfo";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QStringList list = QString::fromLatin1(process->readAllStandardOutput()).split("\n");
    QRegExp rx("Hardware*");
    rx.setPatternSyntax(QRegExp::Wildcard);
    int posfind = list.indexOf(rx);
    if (posfind!= -1) {
        QString ablage(list.at(posfind));
        int t=ablage.indexOf(":");
        ablage=ablage.right(ablage.count() - t - 2);
        ui->label_board->setText("Hardware: \t" + ablage);
    }
    else ui->textEdit_3->setText("not found");
    rx.setPattern("Revision*");
    posfind = list.indexOf(rx);
    if (posfind!= -1) {
        QString ablage(list.at(posfind));
        int t=ablage.indexOf(":");
        ablage=ablage.right(ablage.count() - t - 2);
        ui->label_rev->setText("Revision: \t" + ablage);
    }
    else ui->textEdit_3->setText("not found");
    /*
    int anzlist = list.count();
    ui->textEdit_3->append(QString::number(anzlist));
    for (int i = 1; i < anzlist; ++i){
    ui->textEdit_3->append(list.at(i));
    }*/
}

void MainWindow::on_pushButton_wsave_clicked()
{
    QSettings settings("/home/user/.genwall/network.ini", QSettings::IniFormat);
    settings.beginGroup("Wifi");
    settings.setValue("wip", ui->lineEdit_wip->text());
    settings.setValue("wnetm", ui->lineEdit_wnetmask->text());
    settings.setValue("wdhcp1", ui->lineEdit_wdhcprange1->text());
    settings.setValue("wdhcp2", ui->lineEdit_wdhcprange2->text());
    settings.setValue("wessid", ui->lineEdit_wessid->text());
    settings.setValue("wpass", ui->lineEdit_wpassword->text());
    settings.setValue("wch", ui->spinBox_wchannel->value());
    settings.endGroup();
    QMaemo5InformationBox::information(this, "settings saved",
                                                QMaemo5InformationBox::DefaultTimeout);
}


void MainWindow::on_pushButton_wstartstop_clicked()
{
    QProcess *process = new QProcess(this);
    process->start("/opt/genwall/wifi.sh");
    process->waitForFinished();
    checkwmode();
    wifistatus();
}

void MainWindow::on_pushButton_wadhoc_clicked()
{
    QFileInfo fi("/home/user/.genwall/network.ini");
    if (!fi.exists()) QMaemo5InformationBox::information(this, "please save wifi settings first!", QMaemo5InformationBox::DefaultTimeout);
    else {
    if (checkmodule("wl12xx")==true)
    {

        QProcess *process = new QProcess(this);
        if (wmode("wlan0")==false)
        {
            if (ui->radioButton_wdnslan->isChecked()) process->start("/opt/genwall/hotspot.sh lan");
            else if (ui->radioButton_wdnsfor->isChecked()) process->start("/opt/genwall/hotspot.sh for");
            else if (ui->radioButton_wdnsnone->isChecked()) process->start("/opt/genwall/hotspot.sh");
        }
        else process->start("/opt/genwall/hotspot_off.sh");
        process->waitForFinished();
        checkwmode();
     }
    else QMaemo5InformationBox::information(this, "start wifi first", QMaemo5InformationBox::DefaultTimeout);
    }
}

void MainWindow::wload_ini()
{
    QFileInfo fi("/home/user/.genwall/network.ini");
    if (!fi.exists()){
        QMaemo5InformationBox::information(this, "no file found", QMaemo5InformationBox::DefaultTimeout);
    }
    else {
            QSettings settings("/home/user/.genwall/network.ini", QSettings::IniFormat);
            settings.beginGroup("Wifi");
            ui->lineEdit_wip->setText(settings.value("wip").toString());
            ui->lineEdit_wnetmask->setText(settings.value("wnetm").toString());
            ui->lineEdit_wdhcprange1->setText(settings.value("wdhcp1").toString());
            ui->lineEdit_wdhcprange2->setText(settings.value("wdhcp2").toString());
            ui->lineEdit_wessid->setText(settings.value("wessid").toString());
            ui->lineEdit_wpassword->setText(settings.value("wpass").toString());
            ui->spinBox_wchannel->setValue(settings.value("wch").toInt());
            settings.endGroup();
            //QMaemo5InformationBox::information(this, "settings loaded", QMaemo5InformationBox::DefaultTimeout);
        }
    }
void MainWindow::sshstatus()
{
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "/opt/genwall/ssh-status.sh check";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    int code=process->exitCode();
    //QString tmp=process->readAll();
    if (code==0) {
        ui->label_sshstatus->setText("running");
        ui->label_sshstatus->setStyleSheet("QLabel { background-color : green; }");
    }
    else {
        ui->label_sshstatus->setText("off");
        ui->label_sshstatus->setStyleSheet("QLabel { background-color : red; }");
    }
}

void MainWindow::on_pushButton_sshstartstop_clicked()
{
    ui->label_sshstatus->setStyleSheet("QLabel { background-color : green; }");
    QString prog = "sh";//shell
    QStringList arguments;
    arguments << "-c" << "/opt/genwall/ssh-status.sh change";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    sshstatus();
}

bool MainWindow::wmode(QString dev)
{
    QString prog = "sh";//shell
    //QString prog = "/sbin/ifconfig";
    QStringList arguments;
    arguments << "-c" << "/sbin/iwconfig " + dev + " | grep \"Mode:\" | awk '{print $1}' | sed 's/Mode://'";
    QProcess* process = new QProcess(this);
    process->start(prog, arguments);
    process->waitForFinished();
    QString tmp=process->readAll();
    tmp=tmp.left(tmp.count()-1);
    if (tmp=="Ad-Hoc") return true;
    else return false;
}

void MainWindow::checkwmode()
{
    if (wmode("wlan0")==true) ui->pushButton_wadhoc->setStyleSheet("QPushButton { background-color : green; }");
    else ui->pushButton_wadhoc->setStyleSheet("QPushButton { background-color : red; }");
}
bool MainWindow::checkmodule(QString nmodule)
{
    bool test;
    test=false;
    QFile file("/proc/modules");
    if(!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(0, "error", file.errorString());
    }
    QTextStream in(&file);
        QString line = in.readLine();
        while (!line.isNull()) {
            if (line.contains(nmodule)==true)
            {
                test=true;
                break;
            }
            line = in.readLine();
    }
    file.close();
    if (test==true) return true;
    else return false;
}

void MainWindow::wifistatus()
{
    if (checkmodule("wl12xx")==true) ui->pushButton_wstartstop->setStyleSheet("QPushButton { background-color : green; }");
    else ui->pushButton_wstartstop->setStyleSheet("QPushButton { background-color : red; }");
}
