/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GOOGLEDIRECTIONS_H
#define GOOGLEDIRECTIONS_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QStringList>

#include "directions.h"

class GoogleDirections : public QObject
{
    Q_OBJECT
public:
    explicit GoogleDirections(QNetworkAccessManager *pNetAccessMngr, QObject *parent = 0);
    ~GoogleDirections();

public:
    bool query(QString origin, QString destination,
               QString mode="driving", bool alternatives=false, QString units="metric", QStringList avoid=QStringList());

private:
    QNetworkReply *m_pReply;
    QNetworkAccessManager *m_pNetAccessMngr;

signals:
    void finish(bool success, QString error);

public slots:
    void onFinished();

public:
    QList<Directions>  m_directions;

private:
    QString m_start;
    QString m_end;
};

#endif // GOOGLEDIRECTIONS_H
