/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GEOCODEREQUESTER_H
#define GEOCODEREQUESTER_H

#include <QObject>
#include <QNetworkReply>
#include <QList>
#include <QStringList>

#include "location.h"

class GeocodeAddress : public Location {
public:
    QStringList m_types;
    QString m_location_type;
};

class GeocodeRequester : public QObject
{
    Q_OBJECT

public:
    explicit GeocodeRequester(QNetworkAccessManager *netAccessMngr, QObject *parent = 0);
    ~GeocodeRequester();

public:
    bool query(QString address);
    QNetworkAccessManager *networkAccessManager() { return m_pNetAccessMngr; }

public:
    QList<GeocodeAddress> m_address;

private:
    QNetworkReply *m_pReply;
    QNetworkAccessManager *m_pNetAccessMngr;

signals:
    void finish(bool success, QString error);

public slots:
    void onFinished();
};

#endif // GEOCODEREQUESTER_H
