/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef EVENTLOGGER_UTIL_H_
#define EVENTLOGGER_UTIL_H_

#include <rtcom-eventlogger/eventlogger.h>

#define STORAGE_DIR "MyDocs/FriendStatus"
#define FRIENDS_FILE "friends.txt"
#define MY_FILE "me.txt"

typedef struct _ContactStatus ContactStatus;
struct _ContactStatus
{
  gchar *text;
  gchar *start_time;
};

ContactStatus *eventlogger_util_contact_status_new ();

void eventlogger_util_contact_status_free (ContactStatus *status);

ContactStatus *eventlogger_util_get_contact_status_by_id (RTComEl *eventlogger,
                                                          gint event_id);

ContactStatus *eventlogger_util_get_last_contact_status (RTComEl *eventlogger,
                                                         const gchar *local_uid,
                                                         const gchar *remote_uid);

gint eventlogger_util_get_last_status_id (RTComEl *eventlogger,
                                          const gchar *eventtype);

void eventlogger_util_save_statuses_to_storage (RTComEl *eventlogger,
                                                gint last_friend_status_id,
                                                gint last_my_status_id);

#endif /* EVENTLOGGERUTIL_H_ */
