#include "venuedetails.h"
#include "ui_venuedetails.h"
#include "foursquarecomm.h"
#include <QDebug>

VenueDetails::VenueDetails(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::VenueDetails)
{
    ui->setupUi(this);

    #if defined(Q_WS_MAEMO_5)
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(this->windowFlags()| Qt::Window);

    QFont font;
    font.setPointSize(ui->lblName->font().pointSize()+4);
    font.setBold(true);
    ui->lblName->setFont(font);

    fsc = FoursquareComm::instance();
    ic = new ImageCache(this);
}

VenueDetails::~VenueDetails()
{
    delete ui;
}

void VenueDetails::setVenue(f_venue v)
{
    this->venue = v;
    ui->lblName->setText(v.name);
    this->setLabelText(ui->lblCheckinCount,QString::number(v.checkinsCount));
    this->setLabelText(ui->lblCity,v.location.city);
    this->setLabelText(ui->lblCrossStreet,v.location.crossStreet);
    this->setLabelText(ui->lblHereNow,QString::number(v.hereNowCount));
    this->setLabelText(ui->lblPostalCode,v.location.postalCode);
    this->setLabelText(ui->lblState,v.location.state);
    this->setLabelText(ui->lblStreet,v.location.address);
    this->setLabelText(ui->lblUserCount,QString::number(v.usersCount));
    this->setLabelText(ui->lblDescription,v.description);
    if(!v.extendedInfo)
    {
        watcher = new QFutureWatcher<f_venue>;
        future = new QFuture<f_venue>;
        connect(watcher, SIGNAL(finished()), this, SLOT(venueIsReady()));
        *future = QtConcurrent::run(&getVenueDetails,v.id);
        watcher->setFuture(*future);

        //dit in de achtergrond :
        //this->setVenue(fsc->getVenue(venue.id));

    }
    else
    {
        this->setLabelText(ui->lblMayorName,v.mayor.firstName+" "+v.mayor.lastName);
        QImage image(ic->getImage(v.mayor.photo));
        ui->lblMayorImg->setPixmap(QPixmap::fromImage(image));
        ui->lblMayorCheckinCount->setText(QString::number(v.mayorCheckinCount)+" checkins");
    }
}

void VenueDetails::setLabelText(QLabel * l, QString s)
{
    if(s!="")
    {
        l->setText(s);
        l->show();
    }
    else
        l->hide();
}


void VenueDetails::on_pbCheckin_clicked()
{
    cd = new CheckinDetails();
    cd->setVenue(this->venue);
    cd->exec();

    qDebug() << "on_pbCheckin_clicked done";
}

f_venue VenueDetails::getVenueDetails(QString id)
{
    FoursquareComm * fsc = FoursquareComm::instance();
    return fsc->getVenue(id);
}

void VenueDetails::on_pbAddTip_clicked()
{
    atd = new AddTipDialog(this);
    atd->setVenue(this->venue);
    atd->exec();
}

void VenueDetails::venueIsReady()
{
    qDebug() << "READY VenueDetails::venueIsReady";
    this->setVenue(future->result());
    qDebug() << "READY VenueDetails::venueIsReady DONE";
}
