#include "foursquarecomm.h"
#include <QScriptEngine>
#include <QDebug>
#include <QNetworkAccessManager>
#include <QEventLoop>
#include <QUrl>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QScriptValueIterator>
#include <settings.h>

FoursquareComm* FoursquareComm::inst = NULL;

FoursquareComm::FoursquareComm()
{
    oa = new oAuth();
}

FoursquareComm *FoursquareComm::instance()
{
    if (!inst)
        inst = new FoursquareComm;
    qRegisterMetaType<f_venue>("f_venue"); //to allow a f_venue be emitted
    return inst;
}

QList<f_checkin> FoursquareComm::getRecentCheckins()
{
    QList<f_checkin> items;
    qDebug() << "getRecentCheckins";
    QString a = oa->getUrl("checkins/recent");
    QString result = doRequest(a);
    QScriptEngine engine;
    //sc = engine.evaluate(QString(result)); // In new versions it may need to look like engine.evaluate("(" + QString(result) + ")");
    QScriptValue sc = engine.evaluate("(" + QString(result) + ")");

    QScriptValueIterator it(sc.property("response").property("recent"));
    while (it.hasNext()) {
        it.next();
        if(it.value().property("id").toString()!="")
        {
            items.append(itemToCheckin(it.value()));
        }
    }

    qDebug() << "getRecentCheckins done";
    return items;
}

QList<f_venue> FoursquareComm::searchVenues(QString ll, QString llAcc, QString query)
{
    QList<f_venue> items;
    qDebug() << "searchVenues";
    QString parameters = "&ll="+ll;
    if(query!="")
        parameters.append("&query="+query);
    if(llAcc!="")
        parameters.append("&llAcc="+llAcc);

    QString a = oa->getUrl("venues/search",parameters);
    QString result =  doRequest(a);
    QScriptEngine engine;
    //sc = engine.evaluate(QString(result)); // In new versions it may need to look like engine.evaluate("(" + QString(result) + ")");
    QScriptValue sc = engine.evaluate("(" + QString(result) + ")");
    if(sc.property("meta").property("code").toNumber()!=200)
    {
        qDebug() << "Error occured: "+sc.property("meta").property("code").toString();
        return items;
    }

    QScriptValueIterator it(sc.property("response").property("groups"));
    while (it.hasNext()) {
        it.next();
        if(it.value().property("type").toString()!="")
        {
            qDebug() << "Type:" + it.value().property("type").toString();
            QScriptValueIterator itemsit(it.value().property("items"));
            while(itemsit.hasNext())
            {
                itemsit.next();
                f_venue q = itemToVenue(itemsit.value());
                if(q.name!="")
                    items.append(q);
            }

        }
    }

    qDebug() << "searchVenues done";
    return items;
}

f_venue FoursquareComm::itemToVenue(QScriptValue qv, bool extended)
{

    f_venue v;
    f_location l;

    QScriptValue qsvl = qv.property("location");
    l.address = qsvl.property("address").toString();
    l.city = qsvl.property("city").toString();
    l.distance = qsvl.property("distance").toInteger();
    l.lat = qsvl.property("lat").toString();
    l.lng = qsvl.property("lng").toString();
    l.postalCode = qsvl.property("postalCode").toString();
    l.state = qsvl.property("state").toString();
    l.crossStreet = qsvl.property("crossStreet").toString();

    v.location = l;
    v.name = qv.property("name").toString();
    v.id = qv.property("id").toString();

    //process categories
    QScriptValueIterator itemsit(qv.property("categories"));
    while(itemsit.hasNext())
    {
        itemsit.next();
        f_category q;
        //qDebug() << "cat "+itemsit.value().property("name").toString();
        q.id = itemsit.value().property("id").toString();
        q.name = itemsit.value().property("name").toString();
        q.pluralName = itemsit.value().property("pluralName").toString();
        q.icon = itemsit.value().property("icon").toString();
        q.primary = itemsit.value().property("primary").toBool();
        v.categories.append(q);

        if(q.primary)
            v.icon = q.icon;
    }

    v.checkinsCount = qv.property("stats").property("checkinsCount").toInteger();
    v.usersCount = qv.property("stats").property("usersCount").toInteger();
    v.verified = qv.property("verified").toBool();
    v.hereNowCount = qv.property("hereNow").property("count").toInteger();
    if(extended)
    {
        v.extendedInfo = true;
        v.description = qv.property("description").toString();
        v.stats = qv.property("stats").toString();
        v.mayor = itemToUser(qv.property("mayor").property("user"));
        v.mayorCheckinCount = qv.property("mayor").property("count").toInteger();
        v.tips = qv.property("tips").toString();
        v.todos = qv.property("todos").toString();
        v.tags = qv.property("tags").toString();
        v.beenHere = qv.property("beenHere").toString();
        v.shortUrl = qv.property("shortUrl").toString();
        v.specialsNearby = qv.property("specialsNearby").toString();
        v.photos = qv.property("photos").toString();
        /*QString description;
        f_user mayor;
        QString stats;
        QString tips;
        QString todos;
        QString tags;
        QString beenHere;
        QString shortUrl;
        QString specialsNearby;
        QString photos;*/
    }
    return v;
}

f_checkinresult FoursquareComm::itemToCheckinresult(QScriptValue qv)
{
    f_checkinresult cr;
    cr.type = qv.property("type").toString();

    if(cr.type=="message")
    {
        cr.values.insert("message", qv.property("item").property("message").toString());
        qDebug() << "Message: "+qv.property("item").property("message").toString();
    } else if (cr.type=="mayorship") {
        cr.values.insert("type", qv.property("item").property("type").toString());
        cr.values.insert("checkins", qv.property("item").property("checkins").toString());
        if(qv.property("item").property("daysBehind").isValid())
            cr.values.insert("daysBehind", qv.property("item").property("daysBehind").toString());

        if(qv.property("item").property("user").isValid())
            cr.values.insert("user", qv.property("item").property("user").toString());

        cr.values.insert("message", qv.property("item").property("message").toString());
        qDebug() << "Message: "+qv.property("item").property("message").toString();
        cr.values.insert("image", qv.property("item").property("image").toString());
    } else if (cr.type== "score") {
        QScriptValue scores = qv.property("item").property("scores");
        QScriptValueIterator it(scores);
        int scorecounter = 0;
        while (it.hasNext()) {
            it.next();
            if(it.value().property("points").toString()!="")
            {
                QString score = "";
                QString icon = it.value().property("icon").toString();
                if(icon!="" && !icon.startsWith("http"))
                    icon = "http://foursquare.com"+icon;
                score.append(it.value().property("points").toString()+"|");
                score.append(icon+"|");
                score.append(it.value().property("message").toString());
                cr.values.insert("score"+scorecounter,score);
                scorecounter++;
            }
        }
        cr.values.insert("scorecount",QString::number(scorecounter));

        //qDebug() << "Message: "+qv.property("item").property("message").toString();
        cr.values.insert("total", qv.property("item").property("total").toString());
    } else if (cr.type=="tip") {} //TODO
    else if (cr.type=="badge") {} //TODO

    return cr;
}

QList<f_checkinresult> FoursquareComm::checkinVenue(QString venueId, QString shout, QString broadcast, QString ll, QString llAcc, QString alt, QString altAcc)
{
    QList<f_checkinresult> items;

    qDebug() << "searchVenues";
    QByteArray parameters;
    parameters.append("venueId="+venueId);
    parameters.append("&broadcast="+broadcast);
    parameters.append("&ll="+ll);
    if(llAcc!="")
        parameters.append("&llAcc="+llAcc);
    if(shout!="")
        parameters.append("&shout="+shout);
    QString a = oa->getUrl("checkins/add");
    QNetworkAccessManager * testnam = new QNetworkAccessManager(this);
    qDebug() << "url: "+a;
    qDebug() << "Postdata: "+parameters;
    QUrl url(a);
    QNetworkReply * reply = testnam->post(QNetworkRequest(url),parameters);

    // execute an event loop to process the request (nearly-synchronous)
    QEventLoop eventLoop;
    // also dispose the event loop after the reply has arrived
    connect(testnam, SIGNAL(finished(QNetworkReply *)), &eventLoop, SLOT(quit()));
    eventLoop.exec();

    if (reply->error() == QNetworkReply::NoError)
    {
        QByteArray result = reply->readAll();  // bytes
        qDebug() << QString(result);
        QScriptValue sc;
        QScriptEngine engine;
        sc = engine.evaluate("(" + QString::fromUtf8(result) + ")");

        if(sc.property("meta").property("code").toNumber()!=200)
        {
            qDebug() << "Error occured";
            return items;
        }



        QScriptValueIterator it(sc.property("notifications"));
        while (it.hasNext()) {
            it.next();
            qDebug() << "Message type:" + it.value().property("type").toString();
            if(it.value().property("type").toString()!="")
            {
                f_checkinresult cr = itemToCheckinresult(it.value());
                if(cr.type!="")
                    items.append(cr);
            }
        }
        return items;

    }
    else
    {
        qDebug() << "Error occured: "+reply->errorString();
    }
    qDebug() << "searchVenues done";
    return items;
}

f_user FoursquareComm::itemToUser(QScriptValue qv, bool extended)
{
    f_user u;
    u.id = qv.property("id").toString();
    u.firstName = qv.property("firstName").toString();
    u.gender = qv.property("gender").toString();
    u.homeCity = qv.property("homeCity").toString();
    u.lastName = qv.property("lastName").toString();
    u.photo = qv.property("photo").toString();
    u.relationship = qv.property("relationship").toString();
    if(extended)
    {
        u.extendedInfo = true;
        u.type = qv.property("type").toString();
    }
    return u;
}

f_checkin FoursquareComm::itemToCheckin(QScriptValue qv)
{
    f_checkin c;
    c.id = qv.property("id").toString();
    c.type = qv.property("type").toString();
    c.privateCheckin = qv.property("private").toString();
    c.user = itemToUser(qv.property("user"));
    c.timeZone = qv.property("timeZone").toString();
    c.venue = itemToVenue(qv.property("venue"));
    c.location = qv.property("timeZone").toString();
    c.shout = qv.property("shout").toString();
    c.createdAt = qv.property("createdAt").toString();
    // TODO: correct this:
    /*c.source = qv.property("source");
    c.photos = qv.property("photos");
    c.shout = qv.property("shout");
    c.comments = qv.property("comments");
    c.overlaps = qv.property("overlaps");
    */
    return c;
}

f_venue FoursquareComm::getVenue(QString id)
{
    f_venue detailedvenue;
    qDebug() << "getVenue "+id;
    QString a = oa->getUrl("venues/"+id);
    QString result = doRequest(a);
    QScriptEngine engine;
    //sc = engine.evaluate(QString(result)); // In new versions it may need to look like engine.evaluate("(" + QString(result) + ")");
    QScriptValue sc = engine.evaluate("(" + QString(result) + ")");
    detailedvenue = itemToVenue(sc.property("response").property("venue"),true);
    qDebug() << "getVenue done";
    emit venueReady(detailedvenue);
    return detailedvenue;
}

f_user FoursquareComm::getUser(QString id)
{
    f_user detaileduser;
    qDebug() << "getUser "+id;
    QString a = oa->getUrl("users/"+id);
    QString result = doRequest(a);
    QScriptEngine engine;
    QScriptValue sc = engine.evaluate("(" + QString(result) + ")");

    qDebug() << "MetaCode USER: " +sc.property("meta").property("code").toString();
    detaileduser = itemToUser(sc.property("response").property("user"),true);
    qDebug() << "getUser done";
    return detaileduser;
}

QString FoursquareComm::doRequest(QString a)
{

    QNetworkAccessManager * testnam = new QNetworkAccessManager(this);
    qDebug() << "url: "+a;
    QUrl url(a);
    QNetworkReply * reply = testnam->get(QNetworkRequest(url));
    // execute an event loop to process the request (nearly-synchronous)
    QEventLoop eventLoop;
    // also dispose the event loop after the reply has arrived
    connect(testnam, SIGNAL(finished(QNetworkReply *)), &eventLoop, SLOT(quit()));
    eventLoop.exec();

    if (reply->error() == QNetworkReply::NoError)
    {
        QByteArray result = reply->readAll();  // bytes
        qDebug() << QString::fromUtf8(result);
        return QString::fromUtf8(result);
    } else if (reply->error() == QNetworkReply::AuthenticationRequiredError){
        // TODO foutmelding, geen goed token oid
        qDebug() << "Network error:"+reply->errorString();
    } else {

    }
    return QString("");
}
