from com import Component, msgs
from utils import logging
import platforms

import dbus



class PolicyMonitor(Component):
    """
    Component for monitoring the policy advices.
    The totally undocumented omhd tells us when to mute/unmute the FM radio.
    We just have to listen...
    """

    def __init__(self):

        Component.__init__(self)

        bus = platforms.get_system_bus()
        bus.add_signal_receiver(self.__on_signal,
                                signal_name="audio_actions",
                                dbus_interface="com.nokia.policy",
                                path="/com/nokia/policy/decision")


    def __on_signal(self, decision, policy):
    
        print "POLICY ADVICE"
        limits = policy.get("com.nokia.policy.volume_limit")
        if (limits):
            for s_group, s_value in limits:
                nil, group = s_group
                nil, value = s_value
                
                if (group == "fmradio"):
                    if (value == 0):
                        self.emit_message(msgs.POLICY_EV_FMRADIO_DISALLOWED)
                    else:
                        self.emit_message(msgs.POLICY_EV_FMRADIO_ALLOWED)
                print "  %s: \t%d" % (group, value)
            #end for
        #end if        

