import os


def _read_codetables():
    """
    Reads RDS EBU code tables from a UTF-8 encoded file.
    The codetables are defined by the RDS standard specification:
    ftp://ftp.rds.org.uk/pub/acrobat/rbds1998.pdf
    """

    dirname = os.path.dirname(__file__)
    data = open(os.path.join(dirname, "codetables.utf8"), "r").read()
    data = data.decode("utf-8")

    tables = []
    for block in data.split("\n\n"):
        table = "".join(block.split("\n"))
        tables.append(table)
    #end for
    
    return tables



def decode(s):
    """
    Decodes the given RDS-encoded string to Unicode.
    """

    return u"".join([ _TABLE_1[ord(c) - 0x20] for c in s ])



_TABLE_1, = _read_codetables()

