#!/bin/sh

#Made by sixwheeledbeast, Estel, Malkavian, peterleinchen and vi_

# Setup notification banner
banner(){
o=org
f=freedesktop
n=Notifications
run-standalone.sh dbus-send --type=method_call \
--dest=$o.$f.$n /$o/$f/$n $o.$f.$n.SystemNoteInfoprint string:"$1"
}

# Setup notification dialog
dialog(){
o=org
f=freedesktop
n=Notifications
run-standalone.sh dbus-send --type=method_call \
--dest=$o.$f.$n /$o/$f/$n $o.$f.$n.SystemNoteDialog string:"$1" uint32: string:
}
###########
#Get current swap from /proc/swaps
diskcheck=$(cat /proc/swaps | awk '/dev/ {print $1}' | cut -d "/" -f 3)
echo $diskcheck
if [ $diskcheck == mmcblk0p3 ];
then
banner "Swap Used is not available on device swap"
exit 1
else
echo Swap - Not on device continue...
fi
###########

#Check for existance of last megabytes file
#If not there touch and zero
tempfile=/tmp/flopswaplast
if [ -e $tempfile ]
then
        touch "$tempfile"
else
touch "$tempfile"
echo "0" > "$tempfile"
fi

#Get current swap from /proc/swaps
disk=$(cat /proc/swaps | awk '/dev/ {print $1}' | cut -d "/" -f 3)
#Get blocks used since boot from /proc/diskstats
ublocks=$(awk '{if ($3=="'"$disk"'") print $10}' /proc/diskstats)
echo $ublocks ublocks
########### int32 workaround ##########
###### Should measure swap upto ~2TB ###########
##Multiply blocks by 512 to get used bytes
#ubytes=$(($ublocks*512))
##Calculate used bytes into Kb, Mb and Gb
#echo $ubytes ubytes
#ukbytes=$(($ubytes/1024))
#umbytes=$(($ubytes/1024/1024))
umbytes=$(($ublocks/2048))
#ugbytes=$(($ubytes/1024/1024/1024))
ugbytes=$(($ublocks/1024))
#echo $ukbytes ukbytes, $umbytes umbytes, $ugbytes ugbytes
###########
#Get Swap size from /proc/swaps
swapsize=$(awk '{if ($1=="'"/dev/$disk"'") print $3}' /proc/swaps)
#Divide by 1024 to get swap size in megabytes
swapsizembytes=$(($swapsize/1024))
echo $swapsizembytes swapsizembytes
#Get last megabytes value from /tmp folder
lasttotalsmb=$(cat /tmp/flopswaplast | awk '{print $1}')
echo $lasttotalsmb lasttotalsmb
#Subtract last from current value to get latest used value
getcurrent=$(($umbytes-$lasttotalsmb))
echo $getcurrent getcurrent
timeshundred=$(($getcurrent*100))
echo $timeshundred timeshundred
#Get divide to get percent
getpercent=$(($timeshundred/$swapsizembytes))
echo $getpercent % Fresh Swap Written
#Print banner
banner "$getpercent % Fresh Swap Written
$getcurrent Mb of $swapsizembytes Mb"
#If 94% show warning dialog
if [ $getpercent -ge 94 ]; then
dialog "

***Fresh Swap Recommended***
Used \"$getcurrent Mb ($getpercent)\" of \"$swapsizembytes Mb\"
Device $(hostname) on $(date)

"
fi
