#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "about.h"
#include "help.h"
#include "instructions.h"
#include "settings.h"

#include <QProcess>
#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#include <QShortcut>
#include <QUrl>
#include <QFileInfo>

MainWindow::MainWindow(QWidget *parent):
    QMainWindow(parent), ui(new Ui::MainWindow),
      about(0),
      help(0),
      instructions(0),
      settingspage(0),
      m_process(new QProcess(this))

{
    ui->setupUi(this);

    setAttribute(Qt::WA_Maemo5StackedWindow);
    about = new About(this);
    help = new Help(this);
    instructions = new Instructions(this);
    settingspage = new Settings(this);

  // For Connecting Keyboard Buttons
    connectSignals();

}

MainWindow::~MainWindow()
{
    if (about) delete (about);
    if (help) delete (help);
    if (instructions) delete (instructions);
    if (settingspage) delete (settingspage);
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

  // Keyboard Button Signals - remember to include QShortcut
void MainWindow::connectSignals()
{

  // Keyboard Key Signals
    connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonSwap_clicked()));
    connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonEject_clicked()));
    connect(new QShortcut(QKeySequence(Qt::Key_A), this), SIGNAL(activated()), this, SLOT(on_pushButtonGet_clicked()));
    connect(new QShortcut(QKeySequence(Qt::Key_S), this), SIGNAL(activated()), this, SLOT(on_pushButtonSwapUsage_clicked()));
}

  // End of Keyboard Signals

void MainWindow::on_pushButtonSwap_clicked()
{
    m_process->start("sudo /opt/flopswap/script/swapswitch.sh");
}

void MainWindow::on_pushButtonEject_clicked()
{
    m_process->start("sudo /opt/flopswap/script/swapswitchejectsd.sh");
}

void MainWindow::on_pushButtonGet_clicked()
{
    m_process->start("sudo /opt/flopswap/script/catprocswap.sh");
}

void MainWindow::on_pushButtonSwapUsage_clicked()
{
    m_process->start("sudo /opt/flopswap/script/swapused.sh");
}

void MainWindow::on_actionAbout_triggered()
{
    about->show();
}

void MainWindow::on_actionHelp_triggered()
{
    help->show();
}

void MainWindow::on_actionSettings_triggered()
{
    settingspage->show();
}

void MainWindow::on_actionReadme_triggered()
{
    instructions->show();
}


