/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */
import QtQuick 1.1

Rectangle {
	id: outerRect
	color: "transparent"
	property alias text: ipText.text
	property alias inputMask: ipText.inputMask
	property alias postText: post.text
	signal accepted
	signal focusLost
	signal focusGained
	
	Rectangle {
		id: rect
		border.width: 1
		width: parent.width - post.width;
		height: parent.height
		radius: 2
		
		TextInput{
			id: ipText
			text: ""
			width: parent.width
			font.pointSize: 17
			anchors.verticalCenter: parent.verticalCenter
			anchors.left: parent.left
			anchors.leftMargin: 4
			onAccepted: outerRect.accepted();
			onFocusChanged: {
				if(!focus)
					outerRect.focusLost();
				else
					outerRect.focusGained();
			}
		}
	}
	
	Text{
		id: post
		width: implicitWidth
		font.pointSize: ipText.font.pointSize
		anchors.left: rect.right
		anchors.leftMargin: 5
		anchors.verticalCenter: parent.verticalCenter
	}
	
	states: [
	State {
		name: "disabled"
		//PropertyChanges {target: rect; color: "#f5fef5"; }
		PropertyChanges {target: rect; opacity: 0.5}
		PropertyChanges {target: ipText; readOnly : true}
		
	}
	]
}
