/*
 *  Flashlight applet (widget) for Maemo.
 *  Copyright (C) 2009, 2010 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FLASHLIGHT_LIB_H
#define FLASHLIGHT_LIB_H

#define FLASHLIGHT_STATUS_SHORT_CIRCUT_FAULT		0x0001
#define FLASHLIGHT_STATUS_OVERTEMPERATURE_FAULT		0x0002
#define FLASHLIGHT_STATUS_TIMEOUT_FAULT			0x0004
#define FLASHLIGHT_STATUS_OVERVOLTAGE_FAULT		0x0008

#define ENOERROR	 0
#define EGENERROR	-1
#define ENOCONTEXT	-2
#define ENODEVICE	-3

struct buffer {
	void *start;
	size_t length;
};

struct FlashlightContext {
	/* device name */
	char device_name[15];

	/* file descriptor of device */
	int fd;

	int min_intensity;
	int max_intensity;

	unsigned int n_buffers;
	struct buffer *buffers;
};

typedef struct FlashlightContext FlashlightContext_t;

int flashlight_init (FlashlightContext_t **flashlight);
int flashlight_deinit (FlashlightContext_t *flashlight);

int flashlight_open (FlashlightContext_t *flashlight, const char *device_name);
int flashlight_close (FlashlightContext_t *flashlight);

int flashlight_set_intensity (FlashlightContext_t *flashlight, int intensity);
int flashlight_get_intensity (FlashlightContext_t *flashlight, int *intensity);

int flashlight_get_status (FlashlightContext_t *flashlight, int *status);

#endif
