import Qt 4.7

Item {
    id: container

    signal clicked

    property string text
    property string value

    width: parent.width;
    height: 86;
    //anchors.fill: parent;

//    BorderImage {
//        id: buttonImage
//        source: "images/toolbutton.sci"
//        width: container.width; height: container.height
//    }
//    BorderImage {
//        id: pressed
//        opacity: 0
//        source: "images/toolbutton.sci"
//        width: container.width; height: container.height
//    }

    Rectangle {
        id: back
        width: parent.width;
        height: 82;
        color: "#343434";
        border.width : 4;
        border.color: "black";
        radius: 10;
    }

    Rectangle {
        id: valueSwitch
        color: (value=="False") ? "red" : "green";
        border.width : 4;
        border.color: "black";
        radius: 10;
        height: 40;
        width: 40;
        anchors.verticalCenter: back.verticalCenter
        //anchors.verticalCenter: parent.verticalCenter
        anchors.margins: 10;
        anchors.right: back.right;
        Text {
            color: "white"
            anchors.centerIn: valueSwitch; font.bold: true
            text: (container.value == "False") ? "OFF" : "ON"; style: Text.Raised; styleColor: "black"
        }
    }

    MouseArea {
        id: mouseRegion
        anchors.fill: back
        onClicked: { container.clicked(); }
    }
    Text {
        color: "white"
        /*anchors.centerIn: back;*/ font.bold: true
        anchors.left: parent.left;
        anchors.margins: 10
        anchors.verticalCenter: back.verticalCenter
        text: container.text; style: Text.Raised; styleColor: "black"
    }
//    states: [
//        State {
//            name: "Pressed"
//            when: mouseRegion.pressed == true
//            PropertyChanges { target: pressed; opacity: 1 }
//        }
//    ]
}
