import Qt 4.7

Item {
//    anchors.fill: parent;
    width: 300; //height: 0;
    //anchors.top: parent.top; anchors.bottom: parent.bottom
    y: -parent.height

    function getConfig() {
        //console.log("XX\n")
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var a = doc.responseXML.documentElement;
                //for (var ii = 0; ii < a.childNodes.length; ++ii) {
                //    console.log(ii+ " " + a.childNodes[ii].firstChild.nodeValue);
                //}

                //console.log("node: " + a.childNodes[0].nodeValue)
                config.hideReadFeeds = a.childNodes[0].firstChild.nodeValue;
                config.hideReadArticles = a.childNodes[1].firstChild.nodeValue;
                //console.log("feed " + hideReadFeeds + "\n")
                //console.log("Articles " + hideReadArticles + "\n")
//                showRequestInfo("Headers -->");
//                showRequestInfo(doc.getAllResponseHeaders ());
//                showRequestInfo("Last modified -->");
//                showRequestInfo(doc.getResponseHeader ("Last-Modified"));
            }
        }

        doc.open("GET", "http://localhost:8000/config");
        doc.send();

    }

    Switch {
        id: hideReadFeedsSwitch;
        text: qsTr("Hide Read Feeds");
        value: config.hideReadFeeds
        onClicked: config.hideReadFeeds = (config.hideReadFeeds == "False") ? "True" : "False"
    }

    Switch {
        id: hideReadArticlesSwitch;
        text: qsTr("Hide Read Articles");
        value: config.hideReadArticles
        onClicked: config.hideReadArticles = (config.hideReadArticles == "False") ? "True" : "False"
        anchors.top: hideReadFeedsSwitch.bottom
    }

    Switch {
        id: lockRotation;
        text: qsTr("Lock Rotation");
        value: container.lockRotation ? "True" : "False"
        onClicked: { container.lockRotation=!container.lockRotation;
            container.selectedOrientation = (container.lockRotation) ? container.activeOrientation : Orientation.UnknownOrientation }
        anchors.top: hideReadArticlesSwitch.bottom
    }

    Switch {
        id: editMode;
        text: qsTr("Enter Edit Mode");
        value: container.editMode ? "True" : "False"
        onClicked: { container.editMode=!container.editMode; }
        anchors.top: lockRotation.bottom
    }

    Rectangle {
        id: closeButton
        height: 50;
        gradient: Gradient {
            GradientStop {
                position: 0.00;
                color: "#343434";
            }
            GradientStop {
                position: 1.00;
                color: "#ffffff";
            }
        }
        radius: 10;
        width:  parent.width
        anchors.top: editMode.bottom

        MouseArea {
            id: mouseRegion
            anchors.fill: closeButton
            onClicked: { config.isShown = false }
        }
    }

//    ListView {
//        id: configList; model: configs; delegate: configDelegate; z: 6;
//        cacheBuffer: 100; width: parent.width; height: parent.height;
//    }

//    XmlListModel {

//        id: configs

//        //source: "http://api.flickr.com/services/feeds/photos_public.gne?"+(tags ? "tags="+tags+"&" : "")+"format=rss2"
//        //source: "/home/ymarcoz/feedlist.xml"
//        source: "http://localhost:8000/config"
//        query: "/xml/config"
//        //namespaceDeclarations: "declare namespace media=\"http://search.yahoo.com/mrss/\";"

//        XmlRole { name: "hideReadFeeds"; query: "hideReadFeeds/string()" }
//        XmlRole { name: "hideReadArticles"; query: "hideReadArticles/string()" }
//        //XmlRole { name: "catid"; query: "catid/string()"; isKey: true }

//    }

//    Component {
//        id: configDelegate

//        Item {

//            id: wrapper; width: wrapper.ListView.view.width; height: 86
//            Item {
//                id: moveMe
//                height: parent.height
//                Rectangle { color: "black"; opacity: index % 2 ? 0.2 : 0.4; height: 84; width: wrapper.width; y: 1 }
//                Rectangle {
//                    x: 6; y: 4; width: 77; height: parent.height - 9; color: "white"; smooth: true

//                }
//                Column {
//                    x: 92; width: wrapper.ListView.view.width - 95; y: 15; spacing: 2
//                    Text { text: title; color: "white"; width: parent.width; font.bold: true; elide: Text.ElideRight; style: Text.Raised; styleColor: "black" }
//                    //Text { text: feedname; width: parent.width; elide: Text.ElideLeft; color: "#cccccc"; style: Text.Raised; styleColor: "black" }
//                }
//            }
//            MouseArea { anchors.fill: wrapper; onClicked: { container.categoryClicked(catid); } }
//        }
//    }

    Component.onCompleted: getConfig();
}
