import Qt 4.7

Item {
    //anchors.fill: parent;
    width: parent.width;
    property string catid : ""
    property bool inEditMode: true
    x: parent.width; height: parent.height;
    anchors.top: parent.top; anchors.bottom: parent.bottom

    function reload() {
        feeds.reload()
    }

    //Component.onCompleted: { console.log(x + " /") }

    ListView {
        id: feedList; model: feeds; delegate: feedDelegate; z: 6
        width: parent.width; height: parent.height; /*x: 0;*/
        cacheBuffer: 100;
        flickDeceleration: 1500
    }

    XmlListModel {

        id: feeds

        source: catid == "" ? "" : "http://localhost:8000/feeds/" + catid //+ "?onlyUnread=" + parent.hideReadArticles
        query: "/xml/feed"

        XmlRole { name: "title"; query: "feedname/string()" }
        XmlRole { name: "feedid"; query: "feedid/string()"; isKey: true }
        XmlRole { name: "unread"; query: "unread/string()"; isKey: true }
        XmlRole { name: "updatedDate"; query: "updatedDate/string()" }
        XmlRole { name: "icon"; query: "icon/string()" }
        XmlRole { name: "updating"; query: "updating/string()"; isKey: true }
        //XmlRole { name: "url"; query: "url/string()"; }
    }

    Component {
        id: feedDelegate

        Item {
            id: wrapper; width: wrapper.ListView.view.width;
            visible: (unread == "0" && feedsItem.hideReadFeeds=="True") ? false : true
            height: (visible) ? 86 : 0

            Item {
                id: moveMe
                Rectangle { color: "black"; opacity: index % 2 ? 0.2 : 0.4; height: 84; width: wrapper.width; y: 1 }
                Rectangle {
                    x: 3; y: 4; width: 77; height: 77; color: "#000000"; smooth: true
                    Image { width:32; height: 32; anchors.verticalCenter: parent.verticalCenter; anchors.horizontalCenter: parent.horizontalCenter;
                        source: (updating=="True")? "common/images/loading.png" : (icon == "False") ? "common/images/feedingit.png" : icon;
                        NumberAnimation on rotation {
                            from: 0; to: 360; running: (updating=="True"); loops: Animation.Infinite; duration: 900
                        }
                    }
                }

                Column {
                    x: 92; width: wrapper.ListView.view.width - 95; y: 5; spacing: 2
                    Text { text: title; color: "white"; width: parent.width; font.bold: true; elide: Text.ElideRight; style: Text.Raised; styleColor: "black" }
                    Text { text: updatedDate + " / " + qsTr("%1 unread items").arg(unread); color: (unread=="0") ? "white" : "#7b97fd"; width: parent.width; font.bold: false; elide: Text.ElideRight; style: Text.Raised; styleColor: "black" }
                    //Text { text: feedname; width: parent.width; elide: Text.ElideLeft; color: "#cccccc"; style: Text.Raised; styleColor: "black" }
                }
//                Item {
//                    x: wrapper.ListView.view.width - 128; y: 12
//                    height: 58; width: 58;
//                    //anchors.horizontalCenter: parent.horizontalCenter;
//                    Image { source: "common/images/wmEditIcon.png" }
//                    MouseArea {
//                        anchors.fill: parent; onClicked: { container.feedEdit(feedname, feedid, url); }
//                    }
//                    visible: inEditMode
//                }
                Item {
                    x: wrapper.ListView.view.width - 64; y: 12
                    height: 58; width: 58;
                    //anchors.horizontalCenter: parent.horizontalCenter;
                    Image { source: "common/images/delete.png" }
                    MouseArea {
                        anchors.fill: parent; onClicked: { container.feedDeleted(feedid); }
                    }
                    visible: inEditMode
                }
            }
            MouseArea { anchors.fill: wrapper; onClicked: { container.feedClicked(feedid, updating=="True") } }
        }

    }

}
