/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef LAYOUTMANAGER_H
#define LAYOUTMANAGER_H

#include <QWidget>
#include "textprocessor.h"
#include "core.h"

namespace Ui {
    class LayoutManager;
}

class LayoutManager : public QWidget
{
    Q_OBJECT

public:
    explicit LayoutManager(QWidget *parent = 0);
    ~LayoutManager();
    TextProcessor* getTextProcessor();
    void enableQwerty();
    void enableAlfanum();
    void loadQwertyLayout(Core::QwertyLayout);
    void setLabelColor(Core::LabelColor color);


private:
    Ui::LayoutManager *ui;
};

#endif // LAYOUTMANAGER_H
