/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "kb_qwerty.h"
#include "ui_kb_qwerty.h"
#include <QSettings>

kb_Qwerty::kb_Qwerty(QWidget *parent/*,bool bNewWord, bool bSymbols*/) :
    Keyboard(parent),
    ui(new Ui::kb_Qwerty)
{
    ui->setupUi(this);

    m_nkbType = Core::Qwerty;

    SettingsMenu *menu = SettingsMenu::instance(this);
    ui->btSettings->setMenu(menu);
    connect(menu,SIGNAL(inputStyleChanged(int)),this,SLOT(settingsChanged(int)));

    m_settingsMenu = qobject_cast<SettingsMenu *> (ui->btSettings->menu());
    m_btShift = ui->btShift;
    m_btSymbol = ui->btSymbol;
    m_btAccent = ui->btAccent;

    //add to button group
    m_bgCharacters->addButton(ui->bt_a);
    m_bgCharacters->addButton(ui->bt_b);
    m_bgCharacters->addButton(ui->bt_c);
    m_bgCharacters->addButton(ui->bt_d);
    m_bgCharacters->addButton(ui->bt_e);
    m_bgCharacters->addButton(ui->bt_f);
    m_bgCharacters->addButton(ui->bt_g);
    m_bgCharacters->addButton(ui->bt_h);
    m_bgCharacters->addButton(ui->bt_i);
    m_bgCharacters->addButton(ui->bt_l);
    m_bgCharacters->addButton(ui->bt_m);
    m_bgCharacters->addButton(ui->bt_n);
    m_bgCharacters->addButton(ui->bt_o);
    m_bgCharacters->addButton(ui->bt_p);
    m_bgCharacters->addButton(ui->bt_q);
    m_bgCharacters->addButton(ui->bt_r);
    m_bgCharacters->addButton(ui->bt_s);
    m_bgCharacters->addButton(ui->bt_t);
    m_bgCharacters->addButton(ui->bt_u);
    m_bgCharacters->addButton(ui->bt_v);
    m_bgCharacters->addButton(ui->bt_z);
    m_bgCharacters->addButton(ui->bt_x);
    m_bgCharacters->addButton(ui->bt_y);
    m_bgCharacters->addButton(ui->bt_w);
    m_bgCharacters->addButton(ui->bt_j);
    m_bgCharacters->addButton(ui->bt_k);
    m_bgCharacters->addButton(ui->btPoint);
    m_bgCharacters->addButton(ui->btInterrogative);
    //

    //Setup all connections
    foreach(QAbstractButton *button, m_bgCharacters->buttons())
    {
        connect(button, SIGNAL(released()), this, SLOT(directInputClicked()));
    }

    connect(ui->btNewLine,SIGNAL(released()), this, SLOT(newLineClicked()));
    connect(ui->btDel,SIGNAL(released()), this, SLOT(deleteClicked()));
    connect(ui->btSpace,SIGNAL(released()), this, SLOT(spaceClicked()));
    connect(ui->btShift, SIGNAL(released()), this, SLOT(maiuscClicked()));
    connect(ui->btAccent, SIGNAL(released()), this, SLOT(accentClicked()));
    connect(ui->btSymbol, SIGNAL(released()), this, SLOT(symClicked()));
    //

    //set icons from file: easy customization
    QString iconsPath = QApplication::applicationDirPath() + "/icons/";
    m_btShift->setGraphicNoCheck(iconsPath + "up.png","");
    m_btShift->setGraphicSingleCheck(iconsPath + "up.png","");
    m_btShift->setGraphicDoubleCheck(iconsPath + "up2.png","");
    ui->btSymbol->setGraphicNoCheck(0,"123");
    ui->btSymbol->setGraphicSingleCheck(0,"1/2");
    ui->btSymbol->setGraphicDoubleCheck(0,"2/2");
    ui->btAccent->setGraphicNoCheck(0,QApplication::translate("kb_Qwerty", "\303\250\303\262\303\271", 0, QApplication::UnicodeUTF8));
    ui->btAccent->setGraphicSingleCheck(0,QApplication::translate("kb_Qwerty", "\303\250\303\262\303\271", 0, QApplication::UnicodeUTF8));
    ui->btAccent->setGraphicDoubleCheck(0,QApplication::translate("kb_Qwerty", "\303\210\303\222\303\231", 0, QApplication::UnicodeUTF8));

    ui->btDel->setIcon(QIcon(iconsPath + "delete.png"));
    ui->btSettings->setIcon(QIcon(iconsPath + "preferences.png"));
    ui->btNewLine->setIcon(QIcon(iconsPath + "return.png"));
    //

    //setButtonsLabel();
    loadLayout();

    //setScope(bNewWord,bSymbols);
}

kb_Qwerty::~kb_Qwerty()
{
    delete ui;
}

void kb_Qwerty::setScope(bool bNewWord, bool bSymbol)
{
    if(bNewWord && !bSymbol)
    {
        ui->btSettings->setEnabled(false);
        ui->btNewLine->setEnabled(false);
        ui->btSpace->setEnabled(false);
    }
    else if(bNewWord && bSymbol)
    {
        ui->btSettings->setEnabled(false);
        //ui->btNewLine->setEnabled(true);
        ui->btNewLine->setEnabled(false);
        ui->btSymbol->setState(ThreeStateButton::singleCheck);
        changeInputModifiers(true,MODIFIERS_SYM);
    }    
}

void kb_Qwerty::symClicked()
{
    if(m_btShift->getState()==ThreeStateButton::singleCheck || m_btShift->getState()==ThreeStateButton::doubleCheck)
    {
        m_btShift->setState(ThreeStateButton::noCheck);
        changeInputModifiers(false,MODIFIERS_SHIFT);
    }
    if(ui->btAccent->isChecked())
    {
        m_btAccent->setState(ThreeStateButton::noCheck);
        changeInputModifiers(false,MODIFIERS_ACCENT);
    }

    ThreeStateButton *clickedButton = qobject_cast<ThreeStateButton *>(sender());

    int nState = clickedButton->getState();

    if(nState == ThreeStateButton::noCheck)
    {
        //check if maiusc is needed
        if(m_nActiveStyle == SettingsMenu::AutoCapitalize && CAPITALIZATION_CHAR.contains(m_sLastInputChar))
        {
            m_btShift->setState(ThreeStateButton::singleCheck);
            changeInputModifiers(true,MODIFIERS_SHIFT);
        }
        changeInputModifiers(false,MODIFIERS_SHIFT + MODIFIERS_SYM);
    }
    else if(nState == ThreeStateButton::singleCheck)
        changeInputModifiers(true,MODIFIERS_SYM);
    else if(nState == ThreeStateButton::doubleCheck)
        changeInputModifiers(true,MODIFIERS_SHIFT);
}

void kb_Qwerty::accentClicked()
{
    if(m_btSymbol->getState()==ThreeStateButton::singleCheck)
    {
        m_btSymbol->setState(ThreeStateButton::noCheck);
        changeInputModifiers(false,MODIFIERS_SYM);
    }
    else if(m_btSymbol->getState()==ThreeStateButton::doubleCheck)
    {
        m_btSymbol->setState(ThreeStateButton::noCheck);
        changeInputModifiers(false,MODIFIERS_SYM + MODIFIERS_SHIFT);
    }

    ThreeStateButton *clickedButton = qobject_cast<ThreeStateButton *>(sender());

    int nState = clickedButton->getState();

    if(nState == ThreeStateButton::noCheck)
        changeInputModifiers(false,MODIFIERS_ACCENT);
    else if(nState == ThreeStateButton::singleCheck)
        changeInputModifiers(true,MODIFIERS_ACCENT);
    else if(nState == ThreeStateButton::doubleCheck)
    {//nothing
    }
}

void kb_Qwerty::newLineClicked()
{
    charButtonClicked(Keyboard::NEWLINE,Core::Qwerty);
}

void kb_Qwerty::spaceClicked()
{
    charButtonClicked(Keyboard::SPACE,Core::Qwerty);
}

void kb_Qwerty::deleteClicked()
{
    charButtonClicked(Keyboard::DELETE,Core::Qwerty);
}

void kb_Qwerty::directInputClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());
    QString lastPress = clickedButton->text();

    charButtonClicked(lastPress,Core::Qwerty);
}

void kb_Qwerty::loadLayout(Core::QwertyLayout layout)
{
    if(layout == Core::noneLayout)
    {
        QSettings settings;
        layout = (Core::QwertyLayout)settings.value(Core::SETTING_QWERTY_LAYOUT).toInt();
    }

    m_activeLayout = layout;

    if(m_activeLayout == Core::latinLayout)
    {
        ui->bt_a->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "aA({\303\266", 0, QApplication::UnicodeUTF8)));
        ui->bt_b->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "bB;;\303\261", 0, QApplication::UnicodeUTF8)));
        ui->bt_c->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "cC??\303\273", 0, QApplication::UnicodeUTF8)));
        ui->bt_d->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "dD+^\303\262", 0, QApplication::UnicodeUTF8)));
        ui->bt_e->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "eE3\302\243\303\241", 0, QApplication::UnicodeUTF8)));
        ui->bt_f->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "fF*\\\303\264", 0, QApplication::UnicodeUTF8)));
        ui->bt_g->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "gG=/\303\270", 0, QApplication::UnicodeUTF8)));
        ui->bt_h->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "hH&~\303\255", 0, QApplication::UnicodeUTF8)));
        ui->bt_i->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "iI8>\303\250", 0, QApplication::UnicodeUTF8)));
        ui->bt_l->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "lL^|\303\257", 0, QApplication::UnicodeUTF8)));
        ui->bt_m->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "mM,,\303\247", 0, QApplication::UnicodeUTF8)));
        ui->bt_n->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "nN::\303\275", 0, QApplication::UnicodeUTF8)));
        ui->bt_o->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "oO9[\303\252", 0, QApplication::UnicodeUTF8)));
        ui->bt_p->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "pP0]\303\253", 0, QApplication::UnicodeUTF8)));
        ui->bt_q->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "qQ1\302\247\303\245", 0, QApplication::UnicodeUTF8)));
        ui->bt_r->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "rR4\342\202\254\303\240", 0, QApplication::UnicodeUTF8)));
        ui->bt_s->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "sS)}\303\263", 0, QApplication::UnicodeUTF8)));
        ui->bt_t->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "tT5\302\245\303\243", 0, QApplication::UnicodeUTF8)));
        ui->bt_u->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "uU7<\303\251", 0, QApplication::UnicodeUTF8)));
        ui->bt_v->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "vV!!\303\274", 0, QApplication::UnicodeUTF8)));
        ui->bt_z->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "zZ\"\"\303\272", 0, QApplication::UnicodeUTF8)));
        ui->bt_x->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "xX@@\303\271", 0, QApplication::UnicodeUTF8)));
        ui->bt_y->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "yY6-\303\242", 0, QApplication::UnicodeUTF8)));
        ui->bt_w->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "wW2$\303\244", 0, QApplication::UnicodeUTF8)));
        ui->bt_k->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "kK__\303\256", 0, QApplication::UnicodeUTF8)));
        ui->bt_j->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "jJ--\303\254", 0, QApplication::UnicodeUTF8)));
        ui->btPoint->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "..,'\303\237", 0, QApplication::UnicodeUTF8)));
        ui->btInterrogative->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "??!#\303\246", 0, QApplication::UnicodeUTF8)));
    }
    if(m_activeLayout == Core::khmerLayout)
    {
        ui->bt_a->setProperty("charset","");
        ui->bt_b->setProperty("charset","");
        ui->bt_c->setProperty("charset","");
        ui->bt_d->setProperty("charset","");
        ui->bt_e->setProperty("charset","");
        ui->bt_f->setProperty("charset","");
        ui->bt_g->setProperty("charset","");
        ui->bt_h->setProperty("charset","");
        ui->bt_i->setProperty("charset","");
        ui->bt_l->setProperty("charset","");
        ui->bt_m->setProperty("charset","");
        ui->bt_n->setProperty("charset","");
        ui->bt_o->setProperty("charset","");
        ui->bt_p->setProperty("charset","");
        ui->bt_q->setProperty("charset","");
        ui->bt_r->setProperty("charset","");
        ui->bt_s->setProperty("charset","");
        ui->bt_t->setProperty("charset","");
        ui->bt_u->setProperty("charset","");
        ui->bt_v->setProperty("charset","");
        ui->bt_z->setProperty("charset","");
        ui->bt_x->setProperty("charset","");
        ui->bt_y->setProperty("charset","");
        ui->bt_w->setProperty("charset","");
        ui->bt_k->setProperty("charset","");
        ui->bt_j->setProperty("charset","");
        ui->btPoint->setProperty("charset","");
        ui->btInterrogative->setProperty("charset","");
    }
    if(m_activeLayout == Core::russianLayout)
    {
        ui->bt_q->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\271\320\2311\302\247\303\244\303\204", 0, QApplication::UnicodeUTF8)));
        ui->bt_w->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\206\320\2462$\303\266\303\226", 0, QApplication::UnicodeUTF8)));
        ui->bt_e->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\203\320\2433\342\202\244\303\274\303\234", 0, QApplication::UnicodeUTF8)));
        ui->bt_r->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\272\320\2324\342\202\254\303\237\303\237", 0, QApplication::UnicodeUTF8)));
        ui->bt_t->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\265\320\2255\302\245\303\247\303\207", 0, QApplication::UnicodeUTF8)));
        ui->bt_y->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\275\320\2356\342\204\226\303\270\303\230", 0, QApplication::UnicodeUTF8)));
        ui->bt_u->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\263\320\2237#\303\261\303\221", 0, QApplication::UnicodeUTF8)));
        ui->bt_i->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\210\320\2508&\303\246\303\206", 0, QApplication::UnicodeUTF8)));
        ui->bt_o->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\267\320\2279[\316\276\316\236", 0, QApplication::UnicodeUTF8)));
        ui->bt_p->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\205\320\2450]\317\211\316\251", 0, QApplication::UnicodeUTF8)));
        ui->bt_a->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\204\320\244+<\320\204\320\204", 0, QApplication::UnicodeUTF8)));
        ui->bt_s->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\213\320\253->\322\221\322\220", 0, QApplication::UnicodeUTF8)));
        ui->bt_d->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\262\320\222*/\321\236\320\216", 0, QApplication::UnicodeUTF8)));
        ui->bt_f->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\260\320\220/\\\316\261\317\201", 0, QApplication::UnicodeUTF8)));
        ui->bt_g->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\277\320\237%\342\200\260\316\273\316\243", 0, QApplication::UnicodeUTF8)));
        ui->bt_h->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\200\320\240({\316\274\317\204", 0, QApplication::UnicodeUTF8)));
        ui->bt_j->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\276\320\236)}\317\200\317\200", 0, QApplication::UnicodeUTF8)));
        ui->bt_k->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\273\320\233\302\255=\302\253\316\264\316\224", 0, QApplication::UnicodeUTF8)));
        ui->bt_l->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\264\320\224^\302\273\316\270\316\230", 0, QApplication::UnicodeUTF8)));
        ui->bt_z->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\217\320\257\342\200\234'\321\221\320\201", 0, QApplication::UnicodeUTF8)));
        ui->bt_x->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\207\320\247@|\321\211\320\251", 0, QApplication::UnicodeUTF8)));
        ui->bt_c->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\201\320\241_`\321\226\320\206", 0, QApplication::UnicodeUTF8)));
        ui->bt_v->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\274\320\234:\313\212\321\227\320\207", 0, QApplication::UnicodeUTF8)));
        ui->bt_b->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\270\320\230;\302\251\321\212\320\252", 0, QApplication::UnicodeUTF8)));
        ui->bt_n->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\202\320\242?\302\256\321\215\320\255", 0, QApplication::UnicodeUTF8)));
        ui->bt_m->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\321\214\320\254!~\321\216\320\256", 0, QApplication::UnicodeUTF8)));
        ui->btPoint->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\261\320\221,,,,", 0, QApplication::UnicodeUTF8)));
        ui->btInterrogative->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\320\266\320\226....", 0, QApplication::UnicodeUTF8)));
    }
    if(m_activeLayout == Core::greekLayout)
    {
        ui->bt_q->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", ";:1;;:", 0, QApplication::UnicodeUTF8)));
        ui->bt_w->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\202\317\2022\317\202\317\202\317\202", 0, QApplication::UnicodeUTF8)));
        ui->bt_e->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\265\316\2253$\316\255\316\210", 0, QApplication::UnicodeUTF8)));
        ui->bt_r->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\201\316\2414\342\202\254\317\201\316\241", 0, QApplication::UnicodeUTF8)));
        ui->bt_t->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\204\316\2445\302\243\317\204\316\244", 0, QApplication::UnicodeUTF8)));
        ui->bt_y->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\205\316\2456-\317\215\316\216", 0, QApplication::UnicodeUTF8)));
        ui->bt_u->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\270\316\2307<\316\270\316\230", 0, QApplication::UnicodeUTF8)));
        ui->bt_i->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\271\316\2318>\316\257\316\212", 0, QApplication::UnicodeUTF8)));
        ui->bt_o->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\277\316\2379[\317\214\316\214", 0, QApplication::UnicodeUTF8)));
        ui->bt_p->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\200\316\2400]\317\200\316\240", 0, QApplication::UnicodeUTF8)));
        ui->bt_a->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\261\316\221({\316\254\316\206", 0, QApplication::UnicodeUTF8)));
        ui->bt_s->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\203\316\243)}\317\203\316\243", 0, QApplication::UnicodeUTF8)));
        ui->bt_d->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\264\316\224+\302\261\316\264\316\224", 0, QApplication::UnicodeUTF8)));
        ui->bt_f->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\206\316\246*\\\317\206\316\246", 0, QApplication::UnicodeUTF8)));
        ui->bt_g->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\263\316\223=/\316\263\316\223", 0, QApplication::UnicodeUTF8)));
        ui->bt_h->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\267\316\227%&\316\256\316\211", 0, QApplication::UnicodeUTF8)));
        ui->bt_j->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\276\316\236-\302\275\316\276\316\236", 0, QApplication::UnicodeUTF8)));
        ui->bt_k->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\272\316\232_\302\271\317\212\316\252", 0, QApplication::UnicodeUTF8)));
        ui->bt_l->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\273\316\233^\302\245\316\220\316\220", 0, QApplication::UnicodeUTF8)));
        ui->bt_z->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\266\316\226\"\302\253\316\266\316\226", 0, QApplication::UnicodeUTF8)));
        ui->bt_x->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\207\316\247@\302\273\317\207\316\247", 0, QApplication::UnicodeUTF8)));
        ui->bt_c->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\210\316\250??\317\210\316\250", 0, QApplication::UnicodeUTF8)));
        ui->bt_v->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\317\211\316\251~~\317\216\316\217", 0, QApplication::UnicodeUTF8)));
        ui->bt_b->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\262\316\222;;\316\262\316\222", 0, QApplication::UnicodeUTF8)));
        ui->bt_n->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\275\316\235::\316\275\316\235", 0, QApplication::UnicodeUTF8)));
        ui->bt_m->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", "\316\274\316\234,,\316\274\316\234", 0, QApplication::UnicodeUTF8)));
        ui->btPoint->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", ".,'\".,", 0, QApplication::UnicodeUTF8)));
        ui->btInterrogative->setProperty("charset", QVariant(QApplication::translate("kb_Qwerty", ";!##;!", 0, QApplication::UnicodeUTF8)));
    }

    setButtonsLabel();
}

