/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef DICTIONARY_H
#define DICTIONARY_H

#include  <QtGui>

class dictionary : public QObject
{
    Q_OBJECT

public:
    explicit dictionary(QString *sInputFile, QObject *parent = 0);
    ~dictionary();
    void saveDictionaryToFile();
    bool addWord(QString *sWord);
    void updateWordOrder(QString *sWord);
    bool existsKey(QString *sKey);
    QList<QString> getWordList(QString *key);
    QString* calculateKey(QString *sWord);
    bool isSymbol(QChar car);
    QString *m_sLanguage;

private:
    int init();
    void loadDictLine(QString line, bool bUserDict=false);
    int createTranslater();
    QMultiHash<QString,QString> *m_dict;
    QMultiHash<QString,QString> *m_userDict;
    QMultiHash<QString,QString> *m_hmTranslater;
};

#endif // DICTIONARY_H
