/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "repository.h"
#include "package.h"
#include "aaptinterface.h"

Repository::Repository(): iEnabled(false)
{
}

Repository::~Repository()
{
}

QString Repository::toString() const
{
	QString str;
	if( iEnabled )
		str = "deb ";
	else
		str = "#deb ";

	str += iUrl + iDir + " " + iDist;
	if( !iComponents.isEmpty() )
		str += " " + iComponents;

	return( str.trimmed() );
}

QStringList Repository::toListFileNames() const
{
	QStringList names;

	QStringList com = iComponents.split(' ');
	QString disttext;
	if( com.count()==0 )
		com << "";
	for( int i=0; i<com.count(); i++ ) {
		QString chopUrl = iUrl.mid( iUrl.indexOf("://")+3 );
		if( !com.at(i).isEmpty() )
			disttext = "dists_";
		else
			disttext = "_";
		QString str = chopUrl + iDir + disttext + iDist + "_" + com.at(i);
		if( !com.at(i).isEmpty() )
			str += "_binary-armel_Packages";
		else
			str += "_Packages";
		str.replace('/','_');
		str.replace("___","_");
		str.replace("__","_");
		names << str;
	}

	return names;
}

bool Repository::setFromString(QString repo)
{
	QStringList parts = repo.trimmed().split(' ');
	if( parts.count() < 3 )
		return false;

	if( parts.at(0) == "deb" ) {
		iEnabled=true;
	} else if( parts.at(0) == "#deb" ) {
		iEnabled=false;
	} else {
		return false;
	}

	if( parts.at(1).indexOf("://") == -1 )
		return false;
	int d = parts.at(1).indexOf('/', parts.at(1).indexOf("://")+3 );
	if( d==-1 ) {
		iUrl = parts.at(1);
		iDir = "";
	} else {
		iUrl = parts.at(1).left(d+1);
		iDir = parts.at(1).right( parts.at(1).length()-d-1 );
	}

	if( !parts.at(2).isEmpty() )
		iDist = parts.at(2);
	else
		return false;

	iComponents="";
	if( parts.count()>3 ) {
		for(int i=3; i<parts.count(); i++)
			iComponents += parts.at(i) + " ";
		iComponents = iComponents.trimmed();
	}

	if( iDir != "" ) {
		iName = iDir;
		iName = iName.replace('/',' ').trimmed();
	} else if( iDist != "" ) {
		iName = iDist;
		iName = iName.replace('/',' ').trimmed();
	} else {
		iName = "Unknown";
	}

	/*
	qDebug() << repo << "\n"
			<< iName << "\n"
			<< iUrl << "\n"
			<< iDir << "\n"
			<< iDist << "\n"
			<< iComponents << "\n"
			<< iEnabled << "\n"
			<< toString() << "\n"; */

	set( iName, iUrl, iDir, iDist, iComponents, iEnabled );  // performs further sanity checks

	return true;
}

void Repository::set(QString name, QString url_dir, QString dist, QString components, bool enabled)
{
	QString url;
	QString dir;

	if( url_dir.indexOf("://") == -1 )
		return;
	int d = url_dir.indexOf('/', url_dir.indexOf("://")+3 );
	if( d==-1 ) {
		url = url_dir;
		dir = "";
	} else {
		url = url_dir.left(d+1);
		dir = url_dir.right( url_dir.length()-d-1 );
	}

	set( name, url, dir, dist, components, enabled );
}

void Repository::set(QString name, QString url, QString dir, QString dist, QString components, bool enabled)
{
	iName = name.trimmed();
	iUrl = url.trimmed();
	if( !iUrl.contains("://") )
		iUrl.prepend("http://");
	if( !iUrl.endsWith('/') )
		iUrl.append('/');
	iDir = dir.trimmed();
	if( !iDir.endsWith('/') && !iDir.isEmpty() )
		iDir.append('/');
	iDist = dist.trimmed();
	iComponents = components.trimmed();
	iEnabled = enabled;

	if( iDist.isEmpty() )
		iDist = ".";

	// ensure that the protocol part of the URL is lowercase
	int pos = iUrl.indexOf("://");
	QString proto = iUrl.left(pos);
	iUrl = proto.toLower() + iUrl.mid(pos);
}
