/*******************************************************************************

    This file is a part of Fahrplan for maemo 2009-2010

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

#include "selectstationdialog.h"

selectStationDialog::selectStationDialog(QMaemo5ValueButton *sender, QGeoPositionInfo *position, parserAbstract *mainBackendParser, QSettings *mainSettings)
{
    setWindowTitle(tr("City Stationname"));

    mainSender     = sender;
    myPositionInfo = position;
    backendParser  = mainBackendParser;
    settings       = mainSettings;

    searchbox    = new QLineEdit();
    gpsButton    = new QPushButton(tr("GPS"));
    searchButton = new QPushButton(tr("Search"));
    connect(searchButton, SIGNAL(clicked(bool)), this, SLOT(searchButtonClicked(bool)));
    connect(searchbox, SIGNAL(returnPressed()), this, SLOT(searchReturnPressed()));
    connect(gpsButton, SIGNAL(clicked(bool)), this, SLOT(gpsButtonClicked(bool)));

    if (myPositionInfo->isValid())
    {
        gpsButton->setEnabled(backendParser->supportsGps());

        if (settings->value("openstreetmapfallback", true).toBool() == true)
        {
            gpsButton->setEnabled(true);
        }
    } else
    {
        gpsButton->setEnabled(false);
    }

    QHBoxLayout *hLayout = new QHBoxLayout;
    QVBoxLayout *vLayout = new QVBoxLayout;

    QWidget *vContainer  = new QWidget;

    gpsButton->setMinimumWidth(210);
    searchButton->setMinimumWidth(210);

    vLayout->setMargin(0);
    vLayout->setStretch(0,0);
    vLayout->setSpacing(0);
    vLayout->addWidget(gpsButton);
    vLayout->addWidget(searchButton);
    vContainer->setLayout(vLayout);

    hLayout->setMargin(0);
    hLayout->setStretch(0,0);
    hLayout->setSpacing(0);
    hLayout->addWidget(searchbox);
    hLayout->addWidget(vContainer);

    setLayout(hLayout);
}


void selectStationDialog::showSelector(QStringList items)
{
    //If only one entry found we directly use it.
    if (items.count() == 1)
    {
        mainSender->setValueText(items[0]);
        this->hide();
        return;
    }

    QStandardItemModel * stationsModel = new QStandardItemModel(0, 1);

    QString string;
    foreach(string, items)
    {
        //qDebug() << "- " << string;
        QStandardItem *item = new QStandardItem(string);
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        stationsModel->appendRow(item);
    }

    QMaemo5ValueButton *tmpButton = new QMaemo5ValueButton(tr("Select a station"));
    tmpButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QMaemo5ListPickSelector *tmpSelector = new QMaemo5ListPickSelector;
    connect(tmpSelector, SIGNAL(selected(QString)), this, SLOT(stationSelected(QString)));
    tmpSelector->setModel(stationsModel);
    tmpButton->setPickSelector(tmpSelector);
    tmpButton->click();
}

void selectStationDialog::stationSelected(QString value)
{
    if (value != "")
    {
        mainSender->setValueText(value);
        this->hide();
    }
}

void selectStationDialog::searchReturnPressed()
{
    searchButtonClicked(true);
}

void selectStationDialog::searchButtonClicked(bool checked)
{
    Q_UNUSED(checked);

    searchButton->setEnabled(false);

    QStringList result;

    result = backendParser->getStationsByName(searchbox->text());

    searchButton->setEnabled(true);

    if (result.count() > 0)
    {
        showSelector(result);
    } else
    {
        QMaemo5InformationBox::information(this, "<br>Station not found.<br>", QMaemo5InformationBox::DefaultTimeout);
    }
}

void selectStationDialog::gpsButtonClicked(bool checked)
{
    Q_UNUSED(checked);

    if (myPositionInfo->isValid())
    {
        gpsButton->setEnabled(false);

        // Get the current location as latitude and longitude
        QGeoCoordinate geoCoordinate = myPositionInfo->coordinate();
        qreal latitude = geoCoordinate.latitude();
        qreal longitude = geoCoordinate.longitude();

        QStringList result;

        result = backendParser->getStationsByGPS(latitude, longitude);

        gpsButton->setEnabled(true);

        if (result.count() > 0)
        {
            showSelector(result);
        } else
        {
            if (settings->value("openstreetmapfallback", true).toBool() == true)
            {
                backupGpsOpenstreetmap *fallbackGPS = new backupGpsOpenstreetmap();
                QString cityName = fallbackGPS->getNearestCity(latitude, longitude);

                if (cityName != "")
                {
                    result = backendParser->getStationsByName(cityName);
                }
                if (result.count() > 0)
                {
                    showSelector(result);
                } else
                {
                    QMaemo5InformationBox::information(this, "<br>No station found on GPS position.<br>", QMaemo5InformationBox::DefaultTimeout);
                }
            } else
            {
                QMaemo5InformationBox::information(this, "<br>No station found on GPS position.<br>", QMaemo5InformationBox::DefaultTimeout);
            }
        }
    }
}
