import QtQuick 1.1;
import com.nokia.meego 1.0;

Page {
	id: recordPage;
	anchors.margins: 0;
	orientationLock: PageOrientation.LockPortrait;

	Column {
		spacing: 10;
		anchors.bottom: parent.bottom;
		anchors.bottomMargin: 60;
		width: parent.width;

		Label {
			anchors.horizontalCenter: parent.horizontalCenter;
			visible: rootWin.showStatus;
			text: rootWin.status;
			horizontalAlignment: Text.AlignHCenter;
			width: parent.width;
		}

		Row {
			anchors.horizontalCenter: parent.horizontalCenter;
			visible: rootWin.showDetails;
			Label {
				text: "Artist: ";
			}
			Label {
				id: lblArtist;
				text: rootWin.artist;
				elide: Text.ElideRight;
				wrapMode: Text.Wrap;
			}
		}

		Row {
			anchors.horizontalCenter: parent.horizontalCenter;
			visible: rootWin.showDetails;
			Label {
				text: "Track: ";
			}
			Label {
				id: lblTrack;
				text: rootWin.track;
				elide: Text.ElideRight;
				wrapMode: Text.Wrap;
			}
		}
	
		Button {
			id: btnFind;
			width: parent.width;
			text: rootWin.buttonText;
			onClicked: {
				rootWin.buttonText = "Cancel";
				rootWin.record();
			}
		}

	}

	Menu {
		id: toolMenu;
		content: MenuLayout {

			MenuItem {
				text: "Privacy Policy";
				onClicked: {
					rootWin.fadeImages();
					rootWin.openFile("Privacy.qml");
				}
			}

			MenuItem {
				text: "About";
				onClicked: {
					rootWin.fadeImages();
					rootWin.openFile("About.qml");
				}
			}
		}
	}
}
