#!/bin/sh
export DISPLAY=:0.0
MOUSE_CNT_FILE="/dev/shm/extmou.count"

# wait hildon-desktop to start
if [ ! -e /tmp/hildon-desktop/desktop-started.stamp ]; then
  if [ ! $EXTMOU_SELF_CALLED == "" ]; then
  # we already have been called before hildo-desktop is started, wait for it
    while [ ! -e /tmp/hildon-desktop/desktop-started.stamp ]
    do
      sleep 10
    done
    # lets be generous, give it some more time to calm down
    sleep 15
  else
    export EXTMOU_SELF_CALLED="extmou"
    /usr/lib/hal/hal-setup-mouse-cursor.sh &
    exit 0
  fi
fi 

case $HALD_ACTION in
  add)
    run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connected to $HAL_PROP_INFO_PRODUCT"
    if [ ! -f $MOUSE_CNT_FILE ]; then
      echo 1 > $MOUSE_CNT_FILE
      mv /opt/usr/share/icons/default/cursors /opt/usr/share/icons/default/cursors.extmou
      /opt/usr/bin/extmousecursor --hide
      /opt/usr/bin/extmousecursor --show
    else
      MOUSE_CNT=`cat $MOUSE_CNT_FILE`
      MOUSE_CNT=`expr $MOUSE_CNT + 1`
      echo $MOUSE_CNT > $MOUSE_CNT_FILE
    fi
    ;;
  remove)
    run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Disconnected from $HAL_PROP_INFO_PRODUCT"
    if [ -f $MOUSE_CNT_FILE ]; then
      MOUSE_CNT=`cat $MOUSE_CNT_FILE`
      MOUSE_CNT=`expr $MOUSE_CNT - 1`
      if [ $MOUSE_CNT != '0' ]; then
        echo $MOUSE_CNT > $MOUSE_CNT_FILE
        exit 0
      fi
      rm -f $MOUSE_CNT_FILE
    fi
    mv /opt/usr/share/icons/default/cursors.extmou /opt/usr/share/icons/default/cursors
    /opt/usr/bin/extmousecursor --hide
    /opt/usr/bin/extmousecursor --show
    ;;
esac

