#!/bin/sh

## Download the list of images. Also use this opportunity to check
## the Internet connection and availability of the server.

IMGLIST="imagelist-fremantle-01"

mv $IMGLIST $IMGLIST.old
wget -t 3 http://qole.org/$IMGLIST
if [ $? != 0 ] ; then
  MSG1=`printf "\
Cannot download the list of available images.\n\
Something is wrong with either your Internet connection\n\
or the qole.org file server.\n\n\
Check your Internet connection and the status\n\
of the server by browsing to http://qole.org"`
  gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "Download Error" "$MSG1"
  exit
fi

## Print a warning message before starting the process

export GXMSG=`printf "IMPORTANT NOTE:\n\
To avoid long waits, possible reboots,\n\
and file system corruption, \n\
please close ALL open apps and browser windows \n\
before decompressing the image file."`
gxmessage -center -buttons GTK_STOCK_OK:0 -geometry 690x380 -title "WARNING" "$GXMSG"

## Choose image to download

gxmessage -buttons \
  "`awk -F ',' '/^[0-9],/ {print $2":"$1","}' $IMGLIST`Cancel:0" \
  "`awk -F ',' '/^[0-9],/ {print $2":"$6}' $IMGLIST`" -title "Choose an image to download"
IMGCHOICE=$? 

#Both 0 and 1 are Cancel

if [ "$IMGCHOICE" -le "1" ] ; then
  exit 9
fi

DLURL=`awk -F"," '$1=='$IMGCHOICE' {print $3}' $IMGLIST`
PKGNAME1=`awk -F"," '$1=='"$IMGCHOICE"' {print $6}' $IMGLIST`
BIGTAR1=`awk -F"," '$1=='"$IMGCHOICE"' {print $4"."$5}' $IMGLIST`
BIGIMG1=`awk -F"," '$1=='"$IMGCHOICE"' {print $4}' $IMGLIST`
MD51=`awk -F"," '$1=='"$IMGCHOICE"' {print $7}' $IMGLIST`
IMGCMPRSS=`awk -F"," '$1=='"$IMGCHOICE"' {print $5}' $IMGLIST`

#echo $DLURL
#echo $PKGNAME1
#echo $BIGTAR1
#echo $BIGIMG1
#echo $MD51
#echo $IMGCMPRSS

## Make sure the chroot is closed, to avoid spurious mounts

sudo closechroot >/dev/null

## Ask where the user wishes to install the package with gxmessage:

export GXMSG=`printf "\
Where do you want your Debian image file installed?\n\
You need approximately 2.3GB initially.\n\
Free space left in internal memory or your memory card:\n\n"; \
df -h | grep "mmcblk.p1" | awk '{print $6 ": " $4 " free, " $2 " total (" $5 " full)"}' | sort`
gxmessage -center -buttons MyDocs:2,MicroSD:3 -geometry 690x380 -title "Choose Memory Card" "$GXMSG"
export SDNO=$?

case "$SDNO" in
  2)
    export SDCARD="/home/user/MyDocs" 
    ;;
  3)
    export SDCARD="/media/mmc1" 
    ;;
  *)
    exit 9
    ;;
esac

echo "Downloading and extracting $BIGIMG1 to $SDCARD..."

# exit 0

## HERE ARE THE REST OF THE VARIABLES:

export INSTPATH="/home/user/img-install"
export TARPATH="$SDCARD"
export EXTPATH1=$TARPATH
export EXTCMD1=""

#export CLEANUP="sudo rm -r $INSTPATH ; sudo rm /usr/share/applications/image-install.desktop "
export CLEANUP="echo All done!"

## HERE'S THE SCRIPT:

# Download first package

echo " "
echo "Downloading $PKGNAME1 package..."

export GOTIT="no"

if [ -f $TARPATH/$BIGTAR1 ] ; then
  echo You already have the big image file! 
  echo   Checking to see if it is good...
  if [ "`md5sum  $TARPATH/$BIGTAR1 | awk '{print $1}'`" = "$MD51" ] ; then 
    export GOTIT="yes"
  fi
fi

export GOOD=1
export TEST=2

while test $TEST != $GOOD 
do
 cd $TARPATH
 if [ ! "$GOTIT" = "yes" ] ; then
   wget -c $DLURL/$BIGTAR1
 fi

 if test -e  $TARPATH/$BIGTAR1
  then

   cd $INSTPATH
   export GOOD=$MD51
   if [ ! "$GOTIT" = "yes" ] ; then
     echo Testing the file to see if it is good.
     export TEST=`md5sum  $TARPATH/$BIGTAR1 | awk '{print $1}'`
   else
     export TEST=$MD51
   fi

   if test $TEST = $GOOD
    then

     cd $EXTPATH1

     echo " "
     echo "Changing nr_requests to speed up decompression"
     sudo nr_requests_setup
     echo "Resetting the swap to speed up decompression"
     sudo swapoffon
     if [ "$?" != 0 ] ; then
       MSG1=`printf "\
Cannot reset the system swap.\n\
Please close all applications\n\
and try again."`
       gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "System Error" "$MSG1"
       exit
     fi

# Warn the user that the decompression is going to take a long time.

     export MSG1=`printf "\
Extracting the image file.\n\
This could take a very long time and could\n\
cause your device to become unresponsive."`
     gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "Decompressing" "$MSG1" &

     echo " "
     echo "Extracting $BIGTAR1 package..."

     TARERR="Unknown lzma error"
     # read -p 'press enter' key
     #$TARCMD1
     lzma -kd $TARPATH/$BIGTAR1
     if [ "$?" = 0 ] ; then
	 rm -rf $TARPATH/$BIGTAR1
         $EXTCMD1
         touch /home/user/.synchroot
         /home/user/img-install/msgnotify /usr/share/sounds/game-chess_checkmate.wav
         export MSG1=`printf "CONGRATULATIONS!\n\nAll has gone well!\n\nSuccess installing $PKGNAME1 package!"`
         gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "SUCCESS!" "$MSG1"
       else
         /home/user/img-install/msgnotify /usr/share/sounds/ui-information_note.wav
         export ERR1=`printf "ERROR! DECOMPRESSION FAILED!\nUnable to install $PKGNAME1\n$TARERR"`
         gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x380 -title "DECOMPRESSION ERROR" "$ERR1"
         exit 99
      fi	
    else
      ./msgnotify /usr/share/sounds/ui-information_note.wav
      export ERR1=`printf "$PKGNAME1 package appears damaged.\nPress OK to try downloading again.\nCancel keeps the damaged file."`
      gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0,GTK_STOCK_CANCEL:1 -geometry 640x100 -title "DOWNLOAD ERROR" "$ERR1"
      if [ "$?" = 1 ] ; then
        exit 99
      fi
      rm $TARPATH/$BIGTAR1
    fi
  fi
done

$CLEANUP
exit 0
