/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <libosso.h>

#include "dlh-widget.h"

#define DLH_SERVICE "com.nokia.dlh"
#define DLH_OBJECT  "/com/nokia/dlh"
#define DLH_IFACE   "com.nokia.dlh"

osso_context_t *osso_context;

HD_DEFINE_PLUGIN_MODULE (DlhPlugin, dlh_plugin, HD_TYPE_HOME_PLUGIN_ITEM)

static void startCallback (GtkWidget *widget,
                           gpointer   data)
{
    osso_rpc_run(osso_context,
                 DLH_SERVICE,
                 DLH_OBJECT,
                 DLH_IFACE,
                 "CallStartDialog", NULL, DBUS_TYPE_INVALID);
}

static void appCallback (GtkWidget *widget,
                           gpointer   data)
{
    osso_rpc_run(osso_context,
                 DLH_SERVICE,
                 DLH_OBJECT,
                 DLH_IFACE,
                 "CallViewDialog", NULL, DBUS_TYPE_INVALID);
}

static GtkWidget *build_ui (void)
{
    osso_context = osso_initialize ("com.nokia.dlh-widget", "0.1", 0, NULL);
    
    GtkVBox *contents = GTK_VBOX (gtk_vbox_new (FALSE, 0));
    GtkLabel *label = GTK_LABEL (gtk_label_new ("DLH"));
    
    GtkWidget *start = hildon_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                          HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    GtkWidget *app = hildon_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                        HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text (HILDON_BUTTON (start), "Start", NULL);
    hildon_button_set_text (HILDON_BUTTON (app), "View", NULL);

    GtkHBox *buttons = GTK_HBOX (gtk_hbox_new (TRUE, 5));
    gtk_box_pack_start (GTK_BOX (buttons), GTK_WIDGET (start), FALSE, FALSE, 5);
    gtk_box_pack_end (GTK_BOX (buttons), GTK_WIDGET (app), FALSE, FALSE, 5);
    
    gtk_box_pack_start (GTK_BOX (contents), GTK_WIDGET (label), FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (contents), GTK_WIDGET (buttons), FALSE, FALSE, 5);
    gtk_widget_show_all (GTK_WIDGET (contents)); 

    g_signal_connect (G_OBJECT (start), "clicked",
                      G_CALLBACK (startCallback), NULL);
    g_signal_connect (G_OBJECT (app), "clicked",
                      G_CALLBACK (appCallback), NULL);

    return GTK_WIDGET (contents);
}

static void
dlh_plugin_init (DlhPlugin *desktop_plugin)
{
    GtkWidget *contents = build_ui ();
    gtk_container_add (GTK_CONTAINER (desktop_plugin), contents);
} 

static void
dlh_plugin_class_init (DlhPluginClass *class) {} 

static void
dlh_plugin_class_finalize (DlhPluginClass *class) {
    osso_deinitialize (osso_context);
} 

