/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

Flipable {
    id: field
    //border.width: 1
    width: parent.width / 10
    height: parent.width / 10

    property bool mine: false
    property int hint: 0
    property bool flag: false
    property variant neighbors: new Array()
    property int angle: 0
    property bool flipped: false

    signal opened
    signal flagged(bool status)
    signal gameOver

    transform: Rotation {
        origin.x: field.width/2;
        origin.y: field.height/2;
        axis.x: 0;
        axis.y: 1;
        axis.z: 0;
        angle: field.angle
    }

    states: State {
            name: 'back'
            PropertyChanges { target: field; angle: 180 }
            when: field.flipped
            StateChangeScript {
                script: reveal();
            }
    }

    transitions: Transition {
        RotationAnimation { easing.type: Easing.InOutQuad; duration: 1000 }
    }

    front: Rectangle {
        id: cover
        color: '#00d300'
        anchors.fill: parent
        border.width: 3
        radius: width / 10

        Image {
            id: imgFlag
            source: "images/flag.svg"
            opacity: flag
            Behavior on opacity { NumberAnimation {} }
            anchors.fill: parent
        }

    }

    back: Rectangle {
        anchors.fill: parent
        border.width: 3
        radius: width / 10
        color: '#ab2b00'
        Text {
            id: content
            text: hint
            color: 'white'
            font.pixelSize: field.height * 0.8
            anchors.centerIn: parent
            opacity: !mine && hint > 0
        }

        Image {
            id: bomb
            source: "images/mine.svg"
            anchors.fill: parent
            opacity: mine
        }
    }

    MouseArea {
        anchors.fill: parent;
        acceptedButtons: Qt.LeftButton | Qt.RightButton
        onClicked: {
            if (field.state == 'opened') return;
            if (mouse.button == Qt.RightButton) {
                flag = !flag;
            } else {
                if (flipped || flag) return;
                field.flipped = true;
            }
        }
        onPressAndHold: {
            if (field.state == 'opened') return;
            flag = !flag;
            field.flagged(flag);
        }
    }

    function initialize() {
        mine = false;
        flag = false;
        hint = 0;
        angle = 0;
        flipped = false;
    }

    function setNeighbors(n) {
        neighbors = n;
    }

    function addMine() {
        mine = true;
        for (var i = 0; i < neighbors.length; i++) {
            neighbors[i].mineInNeighborhood();
        }
    }

    function mineInNeighborhood() {
        if (mine) return;
        hint++;
    }

    function reveal() {
        if (mine) {
            field.gameOver();
            return;
        }
        if (flag) {
            return;
        }
        field.opened();
        if (!hint) {
            for (var i = 0; i < neighbors.length; i++) {
                if (neighbors[i].flag) continue;
                neighbors[i].flipped = true;
            }
        }
    }
}
