/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

Rectangle {
    id: options
    width: 800
    height: 480
    anchors.fill: parent
    border.width: 1
    opacity: 0
    visible: opacity > 0
    color: 'black'

    signal canceled
    signal saved(int numOfColumns, int numOfRows, int numOfMines)

    Behavior on opacity {
        NumberAnimation { duration: 1000 }
    }

    Grid {
        spacing: 5
        rows: 5
        columns: 2
        anchors.rightMargin: 20
        anchors.leftMargin: 20
        anchors.bottomMargin: 20
        anchors.topMargin: 20
        anchors.fill: parent

        Text {
            height: numOfColumns.height + 6
            width: parent.width/2
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignRight
            color: "white"
            text: "Columns:"
        }

        Rectangle {
            width: 50
            height: numOfColumns.height + 6
            color: "white"

            TextInput {
                id: numOfColumns
                text: main.columns
                anchors.rightMargin: 3
                anchors.leftMargin: 3
                anchors.bottomMargin: 3
                anchors.topMargin: 3
                anchors.fill: parent
                color: 'black'
                validator: IntValidator {
                    bottom: 2
                    top: 50
                }
            }
        }

        Text {
            height: numOfColumns.height + 6
            width: parent.width/2
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignRight
            color: "white"
            text: "Rows:"
        }

        Rectangle {
            width: 50
            height: numOfRows.height + 6
            color: "white"
            TextInput {
                id: numOfRows
                color: "black"
                text: main.rows
                anchors.fill: parent
                anchors.topMargin: 3
                anchors.rightMargin: 3
                anchors.bottomMargin: 3
                anchors.leftMargin: 3
                validator: IntValidator {
                    top: 50
                    bottom: 2
                }
            }
        }

        Text {
            height: numOfColumns.height + 6
            width: parent.width/2
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignRight
            color: "white"
            text: "Mines:"
        }

        Rectangle {
            width: 50
            height: numOfMines.height + 6
            color: "white"
            TextInput {
                id: numOfMines
                color: "black"
                text: main.mines
                anchors.fill: parent
                anchors.topMargin: 3
                anchors.rightMargin: 3
                anchors.bottomMargin: 3
                anchors.leftMargin: 3
                validator: IntValidator {
                    top: 100
                    bottom: 2
                }
            }
        }

        Rectangle {
            height:btnSave.height
            width: parent.width/2
            color: 'black'
            Button {
                id: btnSave
                text: 'Save'
                anchors.centerIn: parent
                onClicked: {
                    options.saved(parseInt(numOfColumns.text), parseInt(numOfRows.text), parseInt(numOfMines.text));
                    forceClose();
                }
            }
        }
        Rectangle {
            height:btnCancel.height
            width: parent.width/2
            color: 'black'
            Button {
                id: btnCancel
                text: 'Cancel'
                anchors.centerIn: parent
                onClicked: {
                    options.canceled();
                    forceClose();
                }
            }
        }

    }

    function forceClose() {
        if(options.opacity == 0)
            return; //already closed
        options.opacity = 0;
    }

    function show(txt) {
        options.opacity = 1;
    }
}
