#ifndef TRANSFERMOVEDIALOG_H
#define TRANSFERMOVEDIALOG_H

#include "abstractdialog.h"

class TransferListModel;
class QListView;
class QModelIndex;

class TransferMoveDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit TransferMoveDialog(TransferListModel *model, QWidget *parent = 0);
    int currentValue() const;
    void setValue(int value);
    
private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void valueChanged(int value);

private:
    TransferListModel *m_model;
    QListView *m_listView;
};

#endif // TRANSFERMOVEDIALOG_H
