#include "transferlistdelegate.h"
#include "transferlistmodel.h"
#include <QStyleOptionProgressBar>
#include <QApplication>
#include <QPainter>
#include <QMaemo5Style>

TransferListDelegate::TransferListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 5);
    textRect.setRight(textRect.right() - 160);
    textRect.setTop(textRect.top() + 5);
    textRect.setHeight(60);

    painter->drawText(textRect, Qt::TextWordWrap, index.data(TransferListModel::TitleRole).toString());


    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);

    textRect.moveTop(textRect.bottom());
    textRect.setHeight(40);

    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, tr("Priority") + QString(": %1").arg(index.data(TransferListModel::PriorityTextRole).toString()));

    textRect.moveTop(textRect.bottom());

    Transfers::TransferStatus status = static_cast<Transfers::TransferStatus>(index.data(TransferListModel::StatusRole).toInt());

    switch (status) {
    case Transfers::Failed:
        painter->setPen(Qt::red);
        break;
    case Transfers::Paused:
        painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
        break;
    default:
        painter->setPen(QMaemo5Style::standardColor("ActiveTextColor"));
    }

    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, index.data(TransferListModel::StatusTextRole).toString());
    painter->restore();

    QRect progressRect = option.rect;
    progressRect.setLeft(progressRect.right() - 155);
    progressRect.setWidth(150);
    progressRect.setTop(progressRect.top() + 30);
    progressRect.setBottom(progressRect.bottom() - 30);

    int progress = index.data(TransferListModel::ProgressRole).toInt();

    QStyleOptionProgressBar progressBar;
    progressBar.rect = progressRect;
    progressBar.minimum = 0;
    progressBar.maximum = 100;
    progressBar.progress = progress;
    progressBar.text = QString::number(progress) + "%";
    progressBar.textVisible = true;

    QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBar, painter);
}

QSize TransferListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 150);
}
