#include "youtubeuserlistmodel.h"
#include "feedurls.h"
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>

YouTubeUserListModel::YouTubeUserListModel(Session *session, QObject *parent) :
    AbstractUserListModel(session->newThumbnailCache(), parent),
    m_session(session),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void YouTubeUserListModel::setFeed(const QString &afeed) {
    if (afeed.contains("subscriptions")) {
        m_subscriptions = true;
        m_feed = afeed + "&fields=" + YOUTUBE_SUBSCRIPTION_FIELDS;
    }
    else {
        m_subscriptions = false;
        m_feed = afeed + "&fields=" + YOUTUBE_USER_FIELDS;
    }
}

void YouTubeUserListModel::getUsers(const QString &afeed) {
    if (!afeed.isEmpty()) {
        setFeed(afeed);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->youtube()->createReply(feed(), offset());
    connect(reply, SIGNAL(finished()), this, SLOT(addUsers()));
}

void YouTubeUserListModel::search(const QString &aquery) {
    if (!aquery.isEmpty()) {
        setQuery(aquery);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->youtube()->createSearchReply(Queries::Users, query(), offset());
    connect(reply, SIGNAL(finished()), this, SLOT(addUsers()));
    disconnect(m_session->youtube(), SIGNAL(accessTokenRefreshed(QString)), this, SLOT(getUsers()));
}

void YouTubeUserListModel::addUsers() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        setLoading(false);
        setError(true);
        return;
    }

    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();

    if (statusCode == 401) {
        connect(m_session->youtube(), SIGNAL(accessTokenRefreshed(QString)), this, SLOT(getUsers()));
        connect(m_session->youtube(), SIGNAL(refreshError()), this, SLOT(onError()));
        m_session->youtube()->refreshAccessToken();
    }
    else {
        QDomDocument doc;
        doc.setContent(reply->readAll());
        QDomNodeList entries = doc.elementsByTagName("entry");

        for (int i = 0; i < entries.count(); i++) {
            appendUser(QSharedPointer<UserItem>(new UserItem(entries.at(i), m_subscriptions)));
        }

        setLoading(false);
        int totalResults = doc.namedItem("feed").firstChildElement("openSearch:totalResults").text().toInt();
        setMoreResults(totalResults > rowCount());
        setOffset(offset() + 30);

        disconnect(m_session->youtube(), SIGNAL(accessTokenRefreshed(QString)), this, SLOT(getUsers()));
        disconnect(m_session->youtube(), SIGNAL(refreshError()), this, SLOT(onError()));
    }

    reply->deleteLater();
}

void YouTubeUserListModel::getMoreUsers() {
    if ((moreResults()) && (!loading())) {
        if (!query().isEmpty()) {
            search();
        }
        else {
            getUsers();
        }
    }
}
