#include "videoplaybackwindow.h"
#include <QVBoxLayout>

VideoPlaybackWindow::VideoPlaybackWindow(Session *session, QList< QSharedPointer<VideoItem> > playlist, QWidget *parent) :
    StackedWindow(session, parent),
    m_oldOrientation(m_session->settings()->screenOrientation()),
    m_videoWidget(new VideoWidget(this)),
    m_player(new QMediaPlayer(this)),
    m_controls(new VideoControls(m_session, m_player, playlist, this))
{
    setWindowState(Qt::WindowFullScreen);
    setWindowTitle(tr("Now playing"));
    setCentralWidget(new QWidget(this));

    QVBoxLayout *vbox = new QVBoxLayout(centralWidget());
    vbox->setContentsMargins(0, 0, 0, 0);
    vbox->setSpacing(0);
    vbox->addWidget(m_videoWidget);
    vbox->addWidget(m_controls);

    m_session->settings()->setScreenOrientation(ScreenOrientation::LockLandscape);

    m_player->setVideoOutput(m_videoWidget);

    m_controls->hide();

    connect(m_videoWidget, SIGNAL(clicked()), this, SLOT(toggleControls()));
    connect(m_controls, SIGNAL(back()), this, SLOT(close()));
}

VideoPlaybackWindow::~VideoPlaybackWindow() {
    m_player->stop();
    m_session->settings()->setScreenOrientation(m_oldOrientation);
    m_session->preventDisturb(false);
}

void VideoPlaybackWindow::toggleControls() {
    m_controls->setVisible(!m_controls->isVisible());
}

void VideoPlaybackWindow::showEvent(QShowEvent *event) {
    Q_UNUSED(event);

    m_session->preventDisturb(true);
}

void VideoPlaybackWindow::hideEvent(QHideEvent *event) {
    Q_UNUSED(event);

    m_session->preventDisturb(false);
}

void VideoPlaybackWindow::keyPressEvent(QKeyEvent *event) {
    switch (event->key()) {
    case Qt::Key_F:
        toggleControls();
        break;
    case Qt::Key_Backspace:
        close();
        break;
    default:
        m_controls->keyPressEvent(event);
        break;
    }
}
