#include "videolauncher.h"
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>
#include <QProcess>

VideoLauncher::VideoLauncher(QObject *parent) :
    QObject(parent), m_mediaplayer("mediaplayer")
{
}

void VideoLauncher::setMediaPlayer(const QString &player) {
    m_mediaplayer = player.simplified().toLower();
}

void VideoLauncher::setCustomCommand(const QString &command) {
    m_command = command.simplified();
}

void VideoLauncher::launchVideo(const QString &url) {
    if (m_mediaplayer == "other") {
        QStringList args = m_command.split(' ', QString::SkipEmptyParts);
        QProcess *player = new QProcess();
        connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start(args.takeFirst(), args << url);
    }
    else if (m_mediaplayer == "mplayer") {
        QStringList args;
        args << "-cache" << "2048" << "-fs" << url;
        QProcess *player = new QProcess();
        connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start("/usr/bin/mplayer", args);
    }
    else {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + m_mediaplayer, "/com/nokia/" + m_mediaplayer, "com.nokia." + m_mediaplayer, bus);
        dbus_iface.call("mime_open", url);
    }
}
