#ifndef SOCIALVIDEOLISTMODEL_H
#define SOCIALVIDEOLISTMODEL_H

#include "session.h"
#include "abstractvideolistmodel.h"

class SocialVideoListModel : public AbstractVideoListModel
{
    Q_OBJECT

public:
    explicit SocialVideoListModel(Session *session, QObject *parent = 0);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    inline QSharedPointer<VideoItem> get(int row) const { return m_session->sharing()->videos()->at(row); }
    void toggleChecked(int row);
    inline bool itemsChecked() const { return !m_checkedRows.isEmpty(); }
    QList< QSharedPointer<VideoItem> > checkedItems();

public slots:
    void checkAll();
    void checkNone();

private slots:
    void onVideoAdded(int row);

private:
    Session *m_session;
};

#endif // SOCIALVIDEOLISTMODEL_H
